/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.develnext.jphp.ext.game.support.CollisionEvent;
import org.develnext.jphp.ext.game.support.GameScene2D;
import org.develnext.jphp.ext.game.support.Vec2d;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.DetectResult;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ellipse;
import org.dyn4j.geometry.MassType;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Rectangle;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;

public class GameEntity2D
implements EventTarget {
    private static final float TIME = 0.016666668f;
    Body body;
    protected BodyType bodyType = BodyType.STATIC;
    protected SolidType solidType = SolidType.NONE;
    protected Vec2d velocity = new Vec2d(0.0, 0.0);
    protected Vec2d gravity = null;
    private final String entityType;
    private final Node node;
    protected double width = -1.0;
    protected double height = -1.0;
    protected Vector2 center = new Vector2(0.0, 0.0);
    protected boolean gravityFreeze = false;
    protected DoubleProperty x = new SimpleDoubleProperty(0.0);
    protected DoubleProperty y = new SimpleDoubleProperty(0.0);
    protected DoubleProperty rotation = new SimpleDoubleProperty(0.0);
    private Double direction;
    GameScene2D scene;
    protected Map<String, EventHandler<CollisionEvent>> collisionHandlers = new HashMap<String, EventHandler<CollisionEvent>>();
    private boolean horizontalCoordListenerLock = false;
    private boolean verticalCoordListenerLock = false;

    public GameEntity2D(String entityType, Node node) {
        this.entityType = entityType;
        this.node = node;
        this.body = new Body();
        this.body.setUserData((Object)this);
        this.body.setMass(MassType.NORMAL);
        this.body.addFixture((Convex)new Rectangle(this.getWidth(), this.getHeight()));
        this.body.setActive(!node.isDisabled());
        this.xProperty().addListener((observable, oldValue, newValue) -> this.updateBodyPos());
        this.yProperty().addListener((observable, oldValue, newValue) -> this.updateBodyPos());
        this.rotationProperty().addListener((observable, oldValue, newValue) -> node.setRotate(newValue.doubleValue()));
        this.setX(node.getLayoutX());
        this.setY(node.getLayoutY());
        this.setRotation(node.getRotate());
        ChangeListener<Number> verticalCoordListener = this.getVerticalCoordListener(node);
        ChangeListener<Number> horizontalCoordListener = this.getHorizontalCoordListener(node);
        node.layoutYProperty().addListener(verticalCoordListener);
        node.layoutXProperty().addListener(horizontalCoordListener);
        node.layoutXProperty().bindBidirectional((Property)this.x);
        node.layoutYProperty().bindBidirectional((Property)this.y);
        ChangeListener activeTrigger = (observable, oldValue, newValue) -> this.body.setActive(true);
        node.layoutYProperty().addListener(activeTrigger);
        node.layoutYProperty().addListener(activeTrigger);
        node.disabledProperty().addListener((observable, oldValue, newValue) -> this.body.setActive(newValue == false));
    }

    private ChangeListener<Number> getHorizontalCoordListener(Node node) {
        return (observable, oldValue, newValue) -> {
            if (this.scene == null || node == null) {
                return;
            }
            if (this.isSolid() && !node.isDisabled() && this.solidType == SolidType.THING && !this.horizontalCoordListenerLock) {
                List<DetectResult> results = this.scene.detectCollision(this, newValue.doubleValue(), node.getLayoutY());
                this.horizontalCoordListenerLock = true;
                try {
                    for (DetectResult result : results) {
                        GameEntity2D entity = (GameEntity2D)result.getBody().getUserData();
                        if (entity == this || !entity.isSolid()) continue;
                        Vector2 normal = result.getPenetration().getNormal();
                        double depth = result.getPenetration().getDepth();
                        if (entity.isPlatform()) continue;
                        double xValue = newValue.doubleValue() - normal.x * depth;
                        double yValue = node.getLayoutY() - normal.y * depth;
                        node.setLayoutX(xValue);
                        this.setX(xValue);
                        node.setLayoutY(yValue);
                        this.setY(yValue);
                        this.setVelocityX(0.0);
                        if (this.scene != null) {
                            ContactConstraint contact = new ContactConstraint(this.body, (BodyFixture)this.body.getFixture(0), result.getBody(), result.getFixture(), new Manifold(Collections.emptyList(), normal.getNegative()), 1.0, 1.0);
                            this.scene.triggerCollision(contact);
                        }
                        return;
                    }
                }
                finally {
                    this.horizontalCoordListenerLock = false;
                }
            }
        };
    }

    private ChangeListener<Number> getVerticalCoordListener(Node node) {
        return (observable, oldValue, newValue) -> {
            if (this.scene == null || node == null) {
                return;
            }
            if (this.isSolid() && !node.isDisabled() && this.solidType == SolidType.THING && !this.verticalCoordListenerLock) {
                List<DetectResult> results = this.scene.detectCollision(this, node.getLayoutX(), newValue.doubleValue());
                this.verticalCoordListenerLock = true;
                try {
                    for (DetectResult result : results) {
                        GameEntity2D entity = (GameEntity2D)result.getBody().getUserData();
                        if (entity == this || !entity.isSolid()) continue;
                        Vector2 normal = result.getPenetration().getNormal();
                        double depth = result.getPenetration().getDepth();
                        if (entity.isPlatform() && (newValue.doubleValue() <= oldValue.doubleValue() || depth >= 8.0 || normal.y < 0.0)) continue;
                        double yValue = newValue.doubleValue() - normal.y * depth;
                        double xValue = node.getLayoutX() - normal.x * depth;
                        node.setLayoutY(yValue);
                        this.setY(yValue);
                        if (!entity.isPlatform()) {
                            node.setLayoutX(xValue);
                            this.setX(xValue);
                        }
                        this.setVelocityY(0.0);
                        if (this.scene != null) {
                            ContactConstraint contact = new ContactConstraint(this.body, (BodyFixture)this.body.getFixture(0), result.getBody(), result.getFixture(), new Manifold(Collections.emptyList(), normal.getNegative()), 1.0, 1.0);
                            this.scene.triggerCollision(contact);
                        }
                        return;
                    }
                }
                finally {
                    this.verticalCoordListenerLock = false;
                }
            }
        };
    }

    public void setPolygonFixture(Vec2d[] points) {
        this.body.removeAllFixtures();
        Vector2[] _points = new Vector2[points.length];
        for (int i = 0; i < points.length; ++i) {
            _points[i] = new Vector2(points[i].x, points[i].y);
        }
        if (_points.length == 2) {
            this.body.addFixture((Convex)new Segment(_points[0], _points[1]));
        } else if (_points.length == 3) {
            this.body.addFixture((Convex)new Triangle(_points[0], _points[1], _points[2]));
        } else {
            this.body.addFixture((Convex)new Polygon(_points));
        }
    }

    public boolean getActive() {
        return this.body.isActive();
    }

    public void setActive(boolean value) {
        this.body.setActive(value);
    }

    public void setCircleFixture(double radius) {
        this.body.removeAllFixtures();
        this.width = this.height = radius * 2.0;
        Circle circle = new Circle(radius);
        this.center = new Vector2(radius, radius);
        this.body.addFixture((Convex)circle);
    }

    public void setEllipseFixture(double width, double height) {
        this.body.removeAllFixtures();
        this.width = width;
        this.height = height;
        Ellipse ellipse = new Ellipse(width, height);
        this.center = new Vector2(width / 2.0, height / 2.0);
        this.body.addFixture((Convex)ellipse);
    }

    public void setRectangleFixture(double width, double height) {
        this.body.removeAllFixtures();
        this.width = width;
        this.height = height;
        Rectangle rectangle = new Rectangle(width, height);
        this.center = new Vector2(width / 2.0, height / 2.0);
        this.body.addFixture((Convex)rectangle);
    }

    void onSceneAdd() {
        this.updateBodyPos();
    }

    protected void updateBodyPos() {
        if (this.scene == null) {
            return;
        }
        this.body.getTransform().setTranslation(this.getCenterX(), this.getCenterY());
    }

    public DoubleProperty xProperty() {
        return this.x;
    }

    public DoubleProperty yProperty() {
        return this.y;
    }

    public void setX(double v) {
        this.xProperty().set(v);
    }

    public void setY(double y) {
        this.yProperty().set(y);
    }

    public double getX() {
        return this.xProperty().get();
    }

    public double getY() {
        return this.yProperty().get();
    }

    public double getCenterX() {
        return this.getX() + this.center.x;
    }

    public double getCenterY() {
        return this.getY() + this.center.y;
    }

    public void setCenterX(double v) {
        this.setX(v - this.getWidth() / 2.0);
    }

    public void setCenterY(double v) {
        this.setY(v - this.getHeight() / 2.0);
    }

    public Vec2d getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vec2d velocity) {
        this.velocity = velocity == null ? new Vec2d(0.0, 0.0) : velocity;
    }

    public double getHorizontalVelocity() {
        return this.velocity.x;
    }

    public double getVerticalVelocity() {
        return this.velocity.y;
    }

    public void setHorizontalVelocity(double value) {
        this.velocity = new Vec2d(value, this.velocity.y);
    }

    public void setVerticalVelocity(double value) {
        this.velocity = new Vec2d(this.velocity.x, value);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Node getNode() {
        return this.node;
    }

    public double getWidth() {
        if (this.width >= 0.0) {
            return this.width;
        }
        Bounds bounds = this.node.getBoundsInParent();
        double width = bounds.getWidth();
        return width <= 0.0 ? 1.0 : width;
    }

    public double getHeight() {
        if (this.height >= 0.0) {
            return this.height;
        }
        Bounds bounds = this.node.getBoundsInParent();
        double height = bounds.getHeight();
        return height <= 0.0 ? 1.0 : height;
    }

    void update(float dt, GameScene2D scene) {
        switch (this.bodyType) {
            case DYNAMIC: 
            case KINEMATIC: {
                if (!this.body.isActive()) break;
                Vec2d gravity = this.gravity;
                if (gravity == null) {
                    gravity = scene.gravity;
                }
                if (gravity != null) {
                    this.velocity.x += gravity.x * (double)dt;
                    this.velocity.y += gravity.y * (double)dt;
                }
                if (this.velocity.x > 1.0E-5 || this.velocity.x < -0.1) {
                    this.x.set(this.x.get() + (double)GameScene2D.toPixels(this.velocity.x * (double)dt));
                }
                if (!(this.velocity.y > 1.0E-5) && !(this.velocity.y < -0.1)) break;
                this.y.set(this.y.get() + (double)GameScene2D.toPixels(this.velocity.y * (double)dt));
                break;
            }
        }
    }

    public GameScene2D getScene() {
        return this.scene;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }

    public Vec2d getGravity() {
        return this.gravity;
    }

    public void setGravity(Vec2d gravity) {
        this.gravity = gravity;
    }

    public double getGravityX() {
        return this.gravity == null ? 0.0 : this.gravity.x;
    }

    public void setGravityX(double x) {
        if (this.gravity == null) {
            this.gravity = new Vec2d(x, 0.0);
        } else {
            this.gravity.x = x;
        }
    }

    public double getGravityY() {
        return this.gravity.y;
    }

    public void setGravityY(double y) {
        if (this.gravity == null) {
            this.gravity = new Vec2d(0.0, y);
        } else {
            this.gravity.y = y;
        }
    }

    public double getHspeed() {
        return this.getVelocityX();
    }

    public double getVspeed() {
        return this.getVelocityY();
    }

    public void setHspeed(double value) {
        this.setVelocityX(value);
    }

    public void setVspeed(double value) {
        this.setVelocityY(value);
    }

    public double getVelocityX() {
        return this.velocity.x;
    }

    public double getVelocityY() {
        return this.velocity.y;
    }

    public void setVelocityX(double value) {
        this.velocity.x = value;
        this.body.setActive(true);
    }

    public void setVelocityY(double value) {
        this.velocity.y = value;
        this.body.setActive(true);
    }

    public void setAngleSpeed(Vec2d speed) {
        double direction = -Math.toRadians(speed.x);
        this.velocity = new Vec2d(speed.y * Math.cos(direction), speed.y * Math.sin(direction));
        this.body.setActive(true);
    }

    public Vec2d getAngleSpeed() {
        return new Vec2d(this.getDirection(), this.getSpeed());
    }

    public double getSpeed() {
        return this.velocity.length();
    }

    public double getDirection() {
        if (this.direction != null) {
            return this.direction;
        }
        return 360.0 - Math.toDegrees(Math.atan2(this.velocity.y, this.velocity.x));
    }

    public void setDirection(double value) {
        if (this.getSpeed() == 0.0) {
            this.direction = value;
        } else {
            value = -Math.toRadians(value);
            double speed = this.getSpeed();
            this.velocity = new Vec2d(speed * Math.cos(value), speed * Math.sin(value));
        }
        this.body.setActive(true);
    }

    public void setSpeed(double value) {
        double oldDirection = this.getDirection();
        if (this.direction != null) {
            this.setAngleSpeed(new Vec2d(this.direction, value));
            this.direction = null;
        } else {
            this.setAngleSpeed(new Vec2d(this.getDirection(), value));
        }
        if (value == 0.0) {
            this.direction = oldDirection;
        }
        this.body.setActive(true);
    }

    public boolean triggerCollision(GameEntity2D other, ContactConstraint constraint, boolean negative) {
        EventHandler<CollisionEvent> eventHandler = this.collisionHandlers.get(other.getEntityType());
        if (eventHandler != null) {
            CollisionEvent event = new CollisionEvent(this, other, constraint);
            if (negative) {
                event.normal.negateLocal();
            }
            eventHandler.handle((Event)event);
            return event.isConsumed();
        }
        return false;
    }

    public void setCollisionHandler(String entityType, EventHandler<CollisionEvent> collisionHandler) {
        this.collisionHandlers.put(entityType, collisionHandler);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return null;
    }

    public boolean isSolid() {
        return this.solidType != SolidType.NONE;
    }

    public boolean isPlatform() {
        return this.solidType == SolidType.PLATFORM;
    }

    public double getRotation() {
        return this.rotation.get();
    }

    public DoubleProperty rotationProperty() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation.set(rotation);
    }

    public boolean isGravityFreeze() {
        return this.gravityFreeze;
    }

    public void setGravityFreeze(boolean gravityFreeze) {
        this.gravityFreeze = gravityFreeze;
    }

    public SolidType getSolidType() {
        return this.solidType;
    }

    public void setSolidType(SolidType solidType) {
        this.solidType = solidType;
    }

    public boolean isPlaceFree(double x, double y) {
        if (this.scene != null) {
            return this.scene.detectCollision(this, x, y).isEmpty();
        }
        return true;
    }

    public static enum SolidType {
        NONE,
        PLATFORM,
        MATERIAL,
        THING;

    }

    public static enum BodyType {
        STATIC,
        DYNAMIC,
        KINEMATIC;

    }
}

