/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import org.develnext.jphp.ext.game.support.GameScene2D;
import org.develnext.jphp.ext.javafx.support.control.Panel;

public class GamePane
extends Panel {
    protected GameScene2D scene = null;
    protected AnchorPane area;
    protected EventHandler<ActionEvent> onScrollScene;
    protected ObjectProperty<AnchorPane> content = new SimpleObjectProperty(null);

    public GamePane() {
        this.setFocusTraversable(false);
        this.setBorderWidth(0.0);
        this.setBackgroundColor(Color.WHITE);
        this.addEventHandler(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case UP: 
                    case DOWN: 
                    case LEFT: 
                    case SPACE: 
                    case RIGHT: {
                        event.consume();
                    }
                }
            }
        });
        this.addEventFilter(ScrollEvent.ANY, (EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                event.consume();
            }
        });
        this.contentProperty().addListener((ChangeListener)new ChangeListener<AnchorPane>(){

            public void changed(ObservableValue<? extends AnchorPane> observable, AnchorPane oldValue, AnchorPane newValue) {
                if (newValue == null) {
                    GamePane.this.getChildren().clear();
                } else {
                    GamePane.this.getChildren().setAll((Object[])new Node[]{newValue});
                }
            }
        });
        this.setContent(new AnchorPane());
        this.getStyleClass().add((Object)"without-focus");
    }

    public void loadArea(AnchorPane area) {
        this.setContent(area);
        this.requestFocus();
    }

    public AnchorPane getContent() {
        return (AnchorPane)this.content.get();
    }

    public ObjectProperty<AnchorPane> contentProperty() {
        return this.content;
    }

    public void setContent(AnchorPane content) {
        this.content.set((Object)content);
        this.area = content;
        AnchorPane.setLeftAnchor((Node)content, null);
        AnchorPane.setTopAnchor((Node)content, null);
        AnchorPane.setBottomAnchor((Node)content, null);
        AnchorPane.setRightAnchor((Node)content, null);
    }

    public double getViewX() {
        return -this.area.getLayoutX();
    }

    public double getViewY() {
        return -this.area.getLayoutY();
    }

    public double getViewWidth() {
        return this.getPrefWidth();
    }

    public double getViewHeight() {
        return this.getPrefHeight();
    }

    public DoubleProperty viewXProperty() {
        return this.area.layoutXProperty();
    }

    public DoubleProperty viewYProperty() {
        return this.area.layoutYProperty();
    }

    public void scrollTo(double x, double y) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y > this.area.getPrefHeight() - this.getPrefHeight()) {
            y = this.area.getPrefHeight() - this.getPrefHeight();
        }
        if (x > this.area.getPrefWidth() - this.getPrefWidth()) {
            x = this.area.getWidth() - this.getPrefWidth();
        }
        this.area.setClip((Node)new Rectangle(x, y, this.getPrefWidth(), this.getPrefHeight()));
        this.area.setLayoutX(-x);
        this.area.setLayoutY(-y);
        if (this.getOnScrollScene() != null) {
            this.getOnScrollScene().handle((Event)new ActionEvent((Object)this, (EventTarget)this));
        }
    }

    public void setGameScene(GameScene2D scene) {
        if (this.scene != null) {
            this.scene.setScrollHandler(null);
        }
        this.scene = scene;
    }

    public GameScene2D getGameScene() {
        return this.scene;
    }

    public EventHandler<ActionEvent> getOnScrollScene() {
        return this.onScrollScene;
    }

    public void setOnScrollScene(EventHandler<ActionEvent> onScrollScene) {
        this.onScrollScene = onScrollScene;
    }
}

