/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import javafx.animation.AnimationTimer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.develnext.jphp.ext.game.support.Sprite;

public class SpriteView
extends Canvas {
    protected ObjectProperty<Sprite> sprite = new SimpleObjectProperty(null);
    private boolean flipX;
    private boolean flipY;
    private boolean animationEnabled = false;
    private AnimationTimer timer = new AnimationTimer(){

        public void handle(long internalTime) {
            SpriteView.this.update(internalTime);
        }
    };

    public SpriteView() {
        this.setPickOnBounds(false);
        EventHandler<MouseEvent> eventFilter = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (SpriteView.this.sprite.get() == null) {
                    event.consume();
                }
                SnapshotParameters parameters = new SnapshotParameters();
                parameters.setFill((Paint)Color.TRANSPARENT);
                WritableImage snapshot = SpriteView.this.snapshot(parameters, null);
                int x = (int)event.getX();
                int y = (int)event.getY();
                if ((double)x >= snapshot.getWidth() || x < 0 || (double)y >= snapshot.getHeight() || y < 0) {
                    return;
                }
                PixelReader pixelReader = snapshot.getPixelReader();
                double opacity = pixelReader.getColor(x, y).getOpacity();
                if (opacity <= 1.0E-5) {
                    event.consume();
                }
            }
        };
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)eventFilter);
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)eventFilter);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)eventFilter);
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, (EventHandler)eventFilter);
        this.addEventFilter(MouseEvent.MOUSE_EXITED, (EventHandler)eventFilter);
        this.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)eventFilter);
    }

    public SpriteView(Sprite sprite) {
        this();
        this.setSprite(sprite);
    }

    public ObjectProperty<Sprite> spriteProperty() {
        return this.sprite;
    }

    public void setSprite(Sprite sprite) {
        this.sprite.set((Object)(sprite == null ? null : new Sprite(sprite)));
        if (sprite == null) {
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        } else {
            this.setWidth(((Sprite)this.sprite.get()).getFrameWidth());
            this.setHeight(((Sprite)this.sprite.get()).getFrameHeight());
            this.setFlipX(this.flipX);
            this.setFlipY(this.flipY);
            this.setFrame(0);
        }
    }

    public Sprite getSprite() {
        return (Sprite)this.sprite.get();
    }

    public boolean getAnimationEnabled() {
        return this.animationEnabled;
    }

    public String getAnimationName() {
        return ((Sprite)this.sprite.get()).getCurrentAnimation();
    }

    public void setAnimationName(String name) {
        ((Sprite)this.sprite.get()).setCurrentAnimation(name);
    }

    public void setAnimationSpeed(int speed) {
        ((Sprite)this.sprite.get()).setSpeed(speed);
    }

    public int getAnimationSpeed() {
        return ((Sprite)this.sprite.get()).getSpeed();
    }

    public boolean isFlipX() {
        return this.flipX;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            sprite.setFlipX(flipX);
            if (sprite.isFreeze()) {
                this.setFrame(this.getFrame());
            }
        }
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            sprite.setFlipY(flipY);
            if (sprite.isFreeze()) {
                this.setFrame(this.getFrame());
            }
        }
    }

    public void playOnce(String animation) {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            this.setAnimationEnabled(true);
            sprite.setCycledAnimation(false);
            sprite.play(animation);
        }
    }

    public void playOnce(String animation, int speed) {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            this.setAnimationEnabled(true);
            sprite.setCycledAnimation(false);
            sprite.play(animation, speed);
        }
    }

    public void play(String animation) {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            this.setAnimationEnabled(true);
            sprite.setCycledAnimation(true);
            sprite.play(animation);
        }
    }

    public void play(String animation, int speed) {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            this.setAnimationEnabled(true);
            sprite.setCycledAnimation(true);
            sprite.play(animation, speed);
        }
    }

    public boolean isPaused() {
        if (this.getSprite() != null) {
            return this.getSprite().isFreeze();
        }
        return false;
    }

    public void pause() {
        if (this.getSprite() != null) {
            this.getSprite().freeze();
        }
    }

    public void resume() {
        if (this.getSprite() != null) {
            this.getSprite().unfreeze();
        }
    }

    public void setFrame(int index) {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            this.setAnimationEnabled(false);
            sprite.unfreeze();
            sprite.draw(this, index);
            sprite.freeze();
        }
    }

    public int getFrameCount() {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            return sprite.getMaxIndex() + 1;
        }
        return 0;
    }

    public int getFrame() {
        Sprite sprite = this.getSprite();
        if (sprite != null) {
            return sprite.getCurrentIndex();
        }
        return -1;
    }

    public void setAnimationEnabled(boolean value) {
        if (this.animationEnabled != value) {
            this.animationEnabled = value;
            if (value) {
                this.timer.start();
            } else {
                this.timer.stop();
            }
        }
    }

    public final void update(long now) {
        this.onUpdate(now);
    }

    protected void onUpdate(long now) {
        if (!this.animationEnabled) {
            this.timer.stop();
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        Sprite sprite = (Sprite)this.sprite.get();
        if (sprite != null) {
            sprite.drawByTime(this, now);
        }
    }
}

