/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import java.io.Serializable;

public class Vec2d
implements Serializable {
    public static final Vec2d ZERO = new Vec2d(0.0, 0.0);
    public static final float EPSILON = 1.1920929E-7f;
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Vec2d() {
        this(0.0, 0.0);
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2d(Vec2d toCopy) {
        this(toCopy.x, toCopy.y);
    }

    public final void setZero() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public final Vec2d set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public final Vec2d set(Vec2d v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public final Vec2d add(Vec2d v) {
        return new Vec2d(this.x + v.x, this.y + v.y);
    }

    public final Vec2d sub(Vec2d v) {
        return new Vec2d(this.x - v.x, this.y - v.y);
    }

    public final Vec2d mul(float a) {
        return new Vec2d(this.x * (double)a, this.y * (double)a);
    }

    public final Vec2d negate() {
        return new Vec2d(-this.x, -this.y);
    }

    public final Vec2d negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public final Vec2d addLocal(Vec2d v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public final Vec2d addLocal(float x, float y) {
        this.x += (double)x;
        this.y += (double)y;
        return this;
    }

    public final Vec2d subLocal(Vec2d v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public final Vec2d mulLocal(float a) {
        this.x *= (double)a;
        this.y *= (double)a;
        return this;
    }

    public final Vec2d skew() {
        return new Vec2d(-this.y, this.x);
    }

    public final void skew(Vec2d out) {
        out.x = -this.y;
        out.y = this.x;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final double normalize() {
        double length = this.length();
        if (length < 1.1920928955078125E-7) {
            return 0.0;
        }
        double invLength = 1.0 / length;
        this.x *= invLength;
        this.y *= invLength;
        return length;
    }

    public final boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isInfinite(this.x) && !Double.isNaN(this.y) && !Double.isInfinite(this.y);
    }

    public final Vec2d abs() {
        return new Vec2d(Math.abs(this.x), Math.abs(this.y));
    }

    public final void absLocal() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
    }

    public final String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public static final Vec2d abs(Vec2d a) {
        return new Vec2d(Math.abs(a.x), Math.abs(a.y));
    }

    public static final void absToOut(Vec2d a, Vec2d out) {
        out.x = Math.abs(a.x);
        out.y = Math.abs(a.y);
    }

    public static final double dot(Vec2d a, Vec2d b) {
        return a.x * b.x + a.y * b.y;
    }

    public static final double cross(Vec2d a, Vec2d b) {
        return a.x * b.y - a.y * b.x;
    }

    public static final Vec2d cross(Vec2d a, double s) {
        return new Vec2d(s * a.y, -s * a.x);
    }

    public static final void crossToOut(Vec2d a, double s, Vec2d out) {
        double tempy = -s * a.x;
        out.x = s * a.y;
        out.y = tempy;
    }

    public static final void crossToOutUnsafe(Vec2d a, float s, Vec2d out) {
        assert (out != a);
        out.x = (double)s * a.y;
        out.y = (double)(-s) * a.x;
    }

    public static final Vec2d cross(float s, Vec2d a) {
        return new Vec2d((double)(-s) * a.y, (double)s * a.x);
    }

    public static final void crossToOut(float s, Vec2d a, Vec2d out) {
        double tempY = (double)s * a.x;
        out.x = (double)(-s) * a.y;
        out.y = tempY;
    }

    public static final void crossToOutUnsafe(float s, Vec2d a, Vec2d out) {
        assert (out != a);
        out.x = (double)(-s) * a.y;
        out.y = (double)s * a.x;
    }

    public static final void negateToOut(Vec2d a, Vec2d out) {
        out.x = -a.x;
        out.y = -a.y;
    }

    public static final Vec2d min(Vec2d a, Vec2d b) {
        return new Vec2d(a.x < b.x ? a.x : b.x, a.y < b.y ? a.y : b.y);
    }

    public static final Vec2d max(Vec2d a, Vec2d b) {
        return new Vec2d(a.x > b.x ? a.x : b.x, a.y > b.y ? a.y : b.y);
    }

    public static final void minToOut(Vec2d a, Vec2d b, Vec2d out) {
        out.x = a.x < b.x ? a.x : b.x;
        out.y = a.y < b.y ? a.y : b.y;
    }

    public static final void maxToOut(Vec2d a, Vec2d b, Vec2d out) {
        out.x = a.x > b.x ? a.x : b.x;
        out.y = a.y > b.y ? a.y : b.y;
    }

    public int hashCode() {
        int prime = 31;
        long result = 1L;
        result = 31L * result + Double.doubleToLongBits(this.x);
        result = 31L * result + Double.doubleToLongBits(this.y);
        return (int)result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2d other = (Vec2d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

