/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.develnext.jphp.ext.game.support.GameEntity2D;
import org.develnext.jphp.ext.game.support.Vec2d;
import org.dyn4j.Listener;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.CollisionAdapter;
import org.dyn4j.dynamics.DetectResult;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class GameScene2D {
    protected World world;
    private static final float TIME_STEP = 0.016666668f;
    private AnimationTimer timer = new AnimationTimer(){

        public void handle(long internalTime) {
            GameScene2D.this.processUpdate(System.nanoTime());
        }
    };
    protected List<GameEntity2D> entities = new ArrayList<GameEntity2D>();
    protected Vec2d gravity = new Vec2d(0.0, 0.0);
    protected DoubleProperty width = new SimpleDoubleProperty(0.0);
    protected DoubleProperty height = new SimpleDoubleProperty(0.0);
    protected ObjectProperty<GameEntity2D> observedObject = new SimpleObjectProperty(null);
    protected ObjectProperty<ScrollHandler> scrollHandler = new SimpleObjectProperty(null);
    private long previousTime = 0L;

    public GameScene2D() {
        this.world = new World(Capacity.DEFAULT_CAPACITY);
        this.world.addListener((Listener)new CollisionAdapter(){

            public boolean collision(ContactConstraint contact) {
                return GameScene2D.this.triggerCollision(contact);
            }
        });
    }

    public boolean triggerCollision(ContactConstraint contact) {
        GameEntity2D e1 = (GameEntity2D)contact.getBody1().getUserData();
        GameEntity2D e2 = (GameEntity2D)contact.getBody2().getUserData();
        boolean consume1 = !contact.isSensor() && e1.triggerCollision(e2, contact, true);
        boolean consume2 = !contact.isSensor() && e2.triggerCollision(e1, contact, false);
        return consume1 || consume2;
    }

    public List<DetectResult> detectCollision(GameEntity2D entity2D, double x, double y) {
        ArrayList<DetectResult> results = new ArrayList<DetectResult>();
        List fixtures = entity2D.body.getFixtures();
        Transform transform = new Transform();
        transform.setTranslation(x + entity2D.center.x, y + entity2D.center.y);
        for (BodyFixture fixture : fixtures) {
            this.world.detect(fixture.getShape(), transform, null, false, true, true, results);
        }
        return results;
    }

    public void play() {
        this.timer.start();
    }

    public void pause() {
        this.timer.stop();
    }

    public ObjectProperty<GameEntity2D> observedObjectProperty() {
        return this.observedObject;
    }

    public DoubleProperty widthProperty() {
        return this.width;
    }

    public DoubleProperty heightProperty() {
        return this.height;
    }

    public GameEntity2D getObservedObject() {
        return (GameEntity2D)this.observedObject.get();
    }

    public void setObservedObject(GameEntity2D observedObject) {
        this.observedObject.set((Object)observedObject);
    }

    public ScrollHandler getScrollHandler() {
        return (ScrollHandler)this.scrollHandler.get();
    }

    public ObjectProperty<ScrollHandler> scrollHandlerProperty() {
        return this.scrollHandler;
    }

    public void setScrollHandler(ScrollHandler scrollHandler) {
        this.scrollHandler.set((Object)scrollHandler);
    }

    public void setWidth(double v) {
        this.widthProperty().set(v);
    }

    public void setHeight(double v) {
        this.heightProperty().set(v);
    }

    public double getWidth() {
        return this.widthProperty().get();
    }

    public double getHeight() {
        return this.heightProperty().get();
    }

    public static float toMeters(double pixels) {
        return (float)pixels * 0.005f;
    }

    public static float toPixels(double meters) {
        return (float)meters * 20.0f;
    }

    private void processUpdate(long internalTime) {
        if (this.previousTime == 0L) {
            this.previousTime = internalTime;
            return;
        }
        this.previousTime = internalTime;
        this.world.update(0.01666666753590107);
        for (GameEntity2D entity : this.entities) {
            ScrollHandler scrollHandler;
            entity.update(0.016666668f, this);
            GameEntity2D entity2D = (GameEntity2D)this.observedObject.get();
            if (entity2D == null || (scrollHandler = (ScrollHandler)this.scrollHandler.get()) == null) continue;
            scrollHandler.scrollTo(entity.getCenterX(), entity.getCenterY());
        }
    }

    public void addEntity(GameEntity2D entity) {
        if (entity.getScene() == null) {
            entity.scene = this;
            this.entities.add(entity);
            this.world.addBody(entity.body);
            entity.onSceneAdd();
        }
    }

    public void removeEntity(GameEntity2D entity) {
        this.entities.remove(entity);
        this.world.removeBody(entity.body);
        entity.scene = null;
    }

    public void clear() {
        this.world.removeAllBodies();
        for (GameEntity2D entity : this.entities) {
            entity.scene = null;
        }
        this.entities.clear();
    }

    public Vec2d getGravity() {
        return this.gravity;
    }

    public void setGravity(Vec2d gravity) {
        this.gravity = gravity;
        this.world.setGravity(new Vector2(gravity.x, -gravity.y * 10.0));
    }

    public double getGravityX() {
        return this.gravity.x;
    }

    public void setGravityX(double x) {
        this.gravity.x = x;
        this.world.setGravity(new Vector2(this.gravity.x, -this.gravity.y * 10.0));
    }

    public double getGravityY() {
        return this.gravity.y;
    }

    public void setGravityY(double y) {
        this.gravity.y = y;
        this.world.setGravity(new Vector2(this.gravity.x, -this.gravity.y * 10.0));
    }

    public static interface ScrollHandler {
        public void scrollTo(double var1, double var3);
    }
}

