/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FbEmbeddedDatabaseFactory
extends AbstractNativeDatabaseFactory {
    private static final Logger log = LoggerFactory.getLogger(FbEmbeddedDatabaseFactory.class);
    private static final FbEmbeddedDatabaseFactory INSTANCE = new FbEmbeddedDatabaseFactory();

    @Override
    protected FbClientLibrary getClientLibrary() {
        return ClientHolder.clientLibrary;
    }

    @Override
    protected <T extends IAttachProperties<T>> T filterProperties(T attachProperties) {
        T attachPropertiesCopy = attachProperties.asNewMutable();
        attachPropertiesCopy.setServerName(null);
        return attachPropertiesCopy;
    }

    public static FbEmbeddedDatabaseFactory getInstance() {
        return INSTANCE;
    }

    private static final class ClientHolder {
        private static final List<String> LIBRARIES_TO_TRY = Collections.unmodifiableList(Arrays.asList("fbembed", "fbclient"));
        private static final FbClientLibrary clientLibrary = ClientHolder.syncWrapIfNecessary(ClientHolder.initClientLibrary());

        private ClientHolder() {
        }

        private static FbClientLibrary initClientLibrary() {
            ArrayList<UnsatisfiedLinkError> throwables = new ArrayList<UnsatisfiedLinkError>();
            for (String libraryName : LIBRARIES_TO_TRY) {
                try {
                    if (Platform.isWindows()) {
                        return (FbClientLibrary)Native.loadLibrary((String)libraryName, WinFbClientLibrary.class);
                    }
                    return (FbClientLibrary)Native.loadLibrary((String)libraryName, FbClientLibrary.class);
                }
                catch (UnsatisfiedLinkError e) {
                    throwables.add(e);
                    log.debug("Attempt to load " + libraryName + " failed", e);
                }
            }
            assert (throwables.size() == LIBRARIES_TO_TRY.size());
            log.error("Could not load any of the libraries in " + LIBRARIES_TO_TRY + ":");
            for (int idx = 0; idx < LIBRARIES_TO_TRY.size(); ++idx) {
                log.error("Loading " + LIBRARIES_TO_TRY.get(idx) + " failed", (Throwable)throwables.get(idx));
            }
            throw new ExceptionInInitializerError((Throwable)throwables.get(0));
        }

        private static FbClientLibrary syncWrapIfNecessary(FbClientLibrary clientLibrary) {
            if ("true".equalsIgnoreCase(ClientHolder.getSystemPropertyPrivileged("org.firebirdsql.jna.syncWrapNativeLibrary"))) {
                return (FbClientLibrary)Native.synchronizedLibrary((Library)clientLibrary);
            }
            return clientLibrary;
        }

        private static String getSystemPropertyPrivileged(final String propertyName) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }
            });
        }
    }
}

