/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.sql.classes;

import java.io.InputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.develnext.jphp.ext.sql.classes.PSqlResult;
import org.develnext.jphp.ext.sql.classes.WrapSqlException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="SqlStatement")
@Reflection.Namespace(value="php\\sql")
public class PSqlStatement
extends BaseObject
implements Iterator {
    protected PreparedStatement statement;
    protected boolean valid = true;
    private ResultSet resultSet;

    public PSqlStatement(Environment env, PreparedStatement statement) {
        super(env);
        this.statement = statement;
    }

    public PSqlStatement(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public PSqlResult fetch(Environment env) throws SQLException {
        ResultSet resultSet = this.statement.executeQuery();
        if (resultSet.next()) {
            return new PSqlResult(env, resultSet);
        }
        return null;
    }

    @Reflection.Signature
    public boolean execute(Environment env) throws SQLException {
        return this.statement.execute();
    }

    @Reflection.Signature
    public int update(Environment env) throws SQLException {
        return this.statement.executeUpdate();
    }

    @Reflection.Signature
    public Memory getLastInsertId(Environment env) throws SQLException {
        Memory keys = this.getGeneratedKeys(env);
        if (keys.instanceOf(PSqlResult.class)) {
            return ((PSqlResult)keys.toObject(PSqlResult.class)).getTyped(env, 0);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getGeneratedKeys(Environment env) throws SQLException {
        ResultSet keys = this.statement.getGeneratedKeys();
        if (keys != null && keys.next()) {
            return ObjectMemory.valueOf((IObject)new PSqlResult(env, keys));
        }
        return Memory.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public void bindBlob(Environment env, int index, Memory arg) throws SQLException {
        InputStream is = Stream.getInputStream((Environment)env, (Memory)arg);
        try {
            this.statement.setBlob(index + 1, is);
        }
        finally {
            Stream.closeStream((Environment)env, (InputStream)is);
        }
    }

    @Reflection.Signature
    public void bindDate(Environment env, int index, WrapTime time) throws SQLException {
        this.statement.setDate(index + 1, new Date(time.getDate().getTime()), time.getCalendar());
    }

    @Reflection.Signature
    public void bindTime(Environment env, int index, WrapTime time) throws SQLException {
        this.statement.setTime(index + 1, new Time(time.getDate().getTime()), time.getCalendar());
    }

    @Reflection.Signature
    public void bindTimestamp(Environment env, int index, Memory value) throws SQLException {
        if (value.instanceOf(WrapTime.class)) {
            WrapTime time = (WrapTime)value.toObject(WrapTime.class);
            this.statement.setTimestamp(index + 1, new Timestamp(time.getDate().getTime()), time.getCalendar());
        } else {
            this.statement.setTimestamp(index + 1, new Timestamp(value.toLong()));
        }
    }

    @Reflection.Signature
    public void bind(Environment env, int index, Memory value) throws SQLException {
        if (value.instanceOf(WrapTime.class)) {
            WrapTime time = (WrapTime)value.toObject(WrapTime.class);
            this.statement.setDate(index + 1, new Date(time.getDate().getTime()), time.getCalendar());
        } else if (value.instanceOf(Stream.class)) {
            this.statement.setBlob(index + 1, Stream.getInputStream((Environment)env, (Memory)value));
        } else if (value.toValue() instanceof BinaryMemory) {
            this.statement.setBytes(index + 1, value.getBinaryBytes(env.getDefaultCharset()));
        } else if (value.isNull()) {
            this.statement.setNull(index + 1, 0);
        } else {
            switch (value.getRealType()) {
                case INT: {
                    this.statement.setLong(index + 1, value.toLong());
                    break;
                }
                case DOUBLE: {
                    this.statement.setDouble(index + 1, value.toDouble());
                    break;
                }
                case BOOL: {
                    this.statement.setBoolean(index + 1, value.toBoolean());
                    break;
                }
                default: {
                    this.statement.setString(index + 1, value.toString());
                }
            }
        }
    }

    public Memory current(Environment env, Memory ... args) {
        return this.resultSet == null ? Memory.NULL : ObjectMemory.valueOf((IObject)new PSqlResult(env, this.resultSet));
    }

    public Memory key(Environment env, Memory ... args) {
        try {
            return this.resultSet != null ? LongMemory.valueOf((int)(this.resultSet.getRow() - 1)) : Memory.NULL;
        }
        catch (SQLException e) {
            throw new WrapSqlException(env, e);
        }
    }

    public Memory next(Environment env, Memory ... args) {
        try {
            this.valid = this.resultSet == null ? false : this.resultSet.next();
        }
        catch (SQLException e) {
            throw new WrapSqlException(env, e);
        }
        return Memory.NULL;
    }

    public Memory rewind(Environment env, Memory ... args) {
        try {
            this.resultSet = this.statement.executeQuery();
            this.valid = this.resultSet != null ? this.resultSet.next() : false;
        }
        catch (SQLException e) {
            throw new WrapSqlException(env, e);
        }
        return Memory.NULL;
    }

    public Memory valid(Environment env, Memory ... args) {
        return this.valid && this.resultSet != null ? Memory.TRUE : Memory.FALSE;
    }

    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ObjectMemory.valueOf((IObject)this).getNewIterator(env, getReferences, getKeyReferences);
    }

    public ForeachIterator getNewIterator(Environment env) {
        return ObjectMemory.valueOf((IObject)this).getNewIterator(env);
    }
}

