/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.develnext.jphp.ext.javafx.support.control.LabelEx;

public class Panel
extends AnchorPane {
    protected Paint borderColor = Color.SILVER;
    protected BorderStrokeStyle borderStyle = BorderStrokeStyle.SOLID;
    protected CornerRadii borderRadius = new CornerRadii(0.0);
    protected BorderWidths borderWidths = new BorderWidths(1.0);
    protected String title = "";
    protected String _borderStyle = "SOLID";
    protected LabelEx titleLabel;
    protected Pos titlePosition = Pos.TOP_LEFT;
    protected double titleOffset = 15.0;

    public Panel() {
        this.titleLabel = new LabelEx();
        this.titleLabel.setAutoSize(true);
        this.titleLabel.setPadding(new Insets(3.0, 8.0, 3.0, 8.0));
        this.titleLabel.getStyleClass().addAll((Object[])new String[]{"x-system-element", "panel-title"});
        this.titleLabel.setVisible(false);
        this.titleLabel.heightProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(this::updateTitle));
        this.titleLabel.widthProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(this::updateTitle));
        this.updateBorder();
        this.backgroundProperty().addListener((observable, oldValue, newValue) -> this.updateBorder());
        this.getChildren().add((Object)this.titleLabel);
    }

    protected void updateTitle() {
        double x = 0.0;
        switch (this.titlePosition) {
            case TOP_LEFT: {
                x = this.titleOffset;
                break;
            }
            case TOP_CENTER: {
                x = Math.round(this.getWidth() / 2.0 - this.titleLabel.getWidth() / 2.0);
                break;
            }
            case TOP_RIGHT: {
                x = this.getWidth() - this.titleLabel.getWidth() - this.titleOffset;
            }
        }
        this.titleLabel.setLayoutX(x);
        this.titleLabel.setLayoutY(-this.titleLabel.getHeight() + this.borderWidths.getTop() + (double)(this.borderRadius.getTopLeftVerticalRadius() > 0.0 ? 1 : 0));
    }

    protected void updateBorder() {
        Border border = new Border(new BorderStroke[]{new BorderStroke(this.borderColor, this.borderStyle, this.borderRadius, this.borderWidths)});
        this.setBorder(border);
        CornerRadii titleRadius = new CornerRadii(this.borderRadius.getTopLeftHorizontalRadius(), this.borderRadius.getTopRightHorizontalRadius(), 0.0, 0.0, false);
        this.titleLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderColor, this.borderColor, (Paint)Color.TRANSPARENT, this.borderColor, this.borderStyle, this.borderStyle, null, this.borderStyle, titleRadius, this.borderWidths, null)}));
        Background background = this.getBackground();
        if (background != null && background.getFills().size() == 1) {
            boolean update = false;
            for (BackgroundFill backgroundFill : background.getFills()) {
                if (backgroundFill.getRadii().equals((Object)this.borderRadius)) continue;
                update = true;
                break;
            }
            if (update) {
                BackgroundFill[] fills = new BackgroundFill[background.getFills().size()];
                int i = 0;
                for (BackgroundFill backgroundFill : background.getFills()) {
                    fills[i++] = new BackgroundFill(backgroundFill.getFill(), this.borderRadius, backgroundFill.getInsets());
                }
                this.setBackground(new Background(fills));
                this.titleLabel.setBackground(new Background(fills));
            }
        }
        this.updateTitle();
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.setBackground(null);
            this.titleLabel.setBackground(null);
        } else {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
            this.titleLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    public Color getBackgroundColor() {
        Paint fill;
        Background background = this.getBackground();
        if (background != null && background.getFills().size() > 0 && (fill = ((BackgroundFill)background.getFills().get(0)).getFill()) instanceof Color) {
            return (Color)fill;
        }
        return null;
    }

    public Color getBorderColor() {
        return this.borderColor instanceof Color ? (Color)this.borderColor : null;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.updateBorder();
    }

    public String getBorderStyle() {
        return this._borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        try {
            this.borderStyle = (BorderStrokeStyle)BorderStrokeStyle.class.getField(borderStyle.toUpperCase()).get(null);
            this._borderStyle = borderStyle;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Invalid borderStyle - " + borderStyle);
        }
        this.updateBorder();
    }

    public void setBorderRadius(double radius) {
        if (radius < 0.0) {
            radius = 0.0;
        }
        this.borderRadius = new CornerRadii(radius);
        this.updateBorder();
    }

    public double getBorderRadius() {
        return this.borderRadius.getTopLeftHorizontalRadius();
    }

    public double getBorderWidth() {
        return this.borderWidths.getTop();
    }

    public void setBorderWidth(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        this.borderWidths = new BorderWidths(value);
        this.updateBorder();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
        this.titleLabel.setVisible(title != null && !title.isEmpty());
        this.updateTitle();
    }

    public void setTitleColor(Color color) {
        this.titleLabel.setTextFill((Paint)color);
        this.updateTitle();
    }

    public Color getTitleColor() {
        return this.titleLabel.getTextFill() instanceof Color ? (Color)this.titleLabel.getTextFill() : null;
    }

    public Font getTitleFont() {
        return this.titleLabel.getFont();
    }

    public void setTitleFont(Font font) {
        this.titleLabel.setFont(font);
        this.updateTitle();
    }

    public Pos getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(Pos titlePosition) {
        this.titlePosition = titlePosition;
        this.updateTitle();
    }

    public double getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(double titleOffset) {
        this.titleOffset = titleOffset;
        this.updateTitle();
    }
}

