/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.gui.desktop.classes;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.stage.Screen;
import org.develnext.jphp.ext.gui.desktop.classes.Mouse;
import php.runtime.annotation.Reflection;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Namespace(value="php\\desktop")
public class Robot
extends BaseWrapper<java.awt.Robot> {
    public Robot(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Robot(Environment env, java.awt.Robot wrappedObject) {
        super(env, (Object)wrappedObject);
    }

    @Reflection.Signature
    public void __construct() throws AWTException {
        this.__wrappedObject = new java.awt.Robot();
    }

    @Reflection.Getter
    public int getX() {
        return Mouse.x();
    }

    @Reflection.Setter
    public void setX(int x) {
        ((java.awt.Robot)this.getWrappedObject()).mouseMove(x, Mouse.y());
    }

    @Reflection.Getter
    public int getY() {
        return Mouse.y();
    }

    @Reflection.Setter
    public void setY(int y) {
        ((java.awt.Robot)this.getWrappedObject()).mouseMove(Mouse.x(), y);
    }

    @Reflection.Getter
    public int[] getPosition() {
        return new int[]{this.getX(), this.getY()};
    }

    @Reflection.Setter
    public void setPosition(int[] pos) {
        if (pos.length >= 2) {
            this.setX(pos[0]);
            this.setY(pos[1]);
        }
    }

    @Reflection.Signature
    public void mouseClick() {
        this.mouseClick(MouseButton.PRIMARY);
    }

    @Reflection.Signature
    public void mouseClick(MouseButton button) {
        this.mouseDown(button);
        this.mouseUp(button);
    }

    @Reflection.Signature
    public void mouseDown() {
        this.mouseDown(MouseButton.PRIMARY);
    }

    @Reflection.Signature
    public void mouseDown(MouseButton button) {
        switch (button) {
            case PRIMARY: {
                ((java.awt.Robot)this.getWrappedObject()).mousePress(16);
                break;
            }
            case MIDDLE: {
                ((java.awt.Robot)this.getWrappedObject()).mousePress(8);
                break;
            }
            case SECONDARY: {
                ((java.awt.Robot)this.getWrappedObject()).mousePress(4);
            }
        }
    }

    @Reflection.Signature
    public void mouseUp() {
        this.mouseUp(MouseButton.PRIMARY);
    }

    @Reflection.Signature
    public void mouseUp(MouseButton button) {
        switch (button) {
            case PRIMARY: {
                ((java.awt.Robot)this.getWrappedObject()).mouseRelease(16);
                break;
            }
            case MIDDLE: {
                ((java.awt.Robot)this.getWrappedObject()).mouseRelease(8);
                break;
            }
            case SECONDARY: {
                ((java.awt.Robot)this.getWrappedObject()).mouseRelease(4);
            }
        }
    }

    @Reflection.Signature
    public void mouseScroll(int wheelAmt) {
        ((java.awt.Robot)this.getWrappedObject()).mouseWheel(wheelAmt);
    }

    @Reflection.Signature
    public void type(String characters) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(characters);
        clipboard.setContents(stringSelection, null);
        ((java.awt.Robot)this.getWrappedObject()).keyPress(17);
        ((java.awt.Robot)this.getWrappedObject()).keyPress(86);
        ((java.awt.Robot)this.getWrappedObject()).keyRelease(86);
        ((java.awt.Robot)this.getWrappedObject()).keyRelease(17);
    }

    protected List<Integer> keyCodes(String keys) {
        String[] strings = StringUtils.split((String)keys, (char)'+');
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (String string : strings) {
            string = string.trim().replace(' ', '_').replace('-', '_').toUpperCase();
            try {
                Field field = KeyEvent.class.getField("VK_" + string);
                int code = field.getInt(null);
                codes.add(code);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Unknown key - " + string);
            }
        }
        if (codes.isEmpty()) {
            throw new IllegalArgumentException("Key combination cannot be empty");
        }
        return codes;
    }

    @Reflection.Signature
    public void keyDown(String keys) {
        for (Integer code : this.keyCodes(keys)) {
            ((java.awt.Robot)this.getWrappedObject()).keyPress(code);
        }
    }

    @Reflection.Signature
    public void keyUp(String keys) {
        for (Integer code : this.keyCodes(keys)) {
            ((java.awt.Robot)this.getWrappedObject()).keyRelease(code);
        }
    }

    @Reflection.Signature
    public void keyPress(String keys) {
        List<Integer> codes = this.keyCodes(keys);
        for (Integer code : codes) {
            ((java.awt.Robot)this.getWrappedObject()).keyPress(code);
        }
        Collections.reverse(codes);
        for (Integer code : codes) {
            ((java.awt.Robot)this.getWrappedObject()).keyRelease(code);
        }
    }

    @Reflection.Signature
    public Image screenshot() {
        return this.screenshot(null);
    }

    @Reflection.Signature
    public Image screenshot(@Reflection.Nullable Rectangle2D bounds) {
        return this.screenshot(bounds, null);
    }

    @Reflection.Signature
    public Image screenshot(@Reflection.Nullable Rectangle2D bounds, @Reflection.Nullable Screen screen) {
        screen = screen == null ? Screen.getPrimary() : screen;
        bounds = bounds == null ? screen.getVisualBounds() : bounds;
        return this.screenshotArea((int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    protected Image screenshotArea(int x, int y, int width, int height) {
        BufferedImage capture = ((java.awt.Robot)this.getWrappedObject()).createScreenCapture(new Rectangle(x, y, width, height));
        return SwingFXUtils.toFXImage((BufferedImage)capture, null);
    }

    static interface WrappedInterface {
    }
}

