/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class JFXDialogLayout
extends StackPane {
    private StackPane heading = new StackPane();
    private StackPane body = new StackPane();
    private FlowPane actions = new FlowPane();
    private static final String DEFAULT_STYLE_CLASS = "jfx-dialog-layout";

    public JFXDialogLayout() {
        this.initialize();
        VBox layout = new VBox();
        layout.getChildren().add((Object)this.heading);
        this.heading.getStyleClass().add((Object)"jfx-layout-heading");
        this.heading.getStyleClass().add((Object)"title");
        layout.getChildren().add((Object)this.body);
        this.body.getStyleClass().add((Object)"jfx-layout-body");
        this.body.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.body.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        layout.getChildren().add((Object)this.actions);
        this.actions.getStyleClass().add((Object)"jfx-layout-actions");
        this.getChildren().add((Object)layout);
    }

    public ObservableList<Node> getHeading() {
        return this.heading.getChildren();
    }

    public void setHeading(Node ... titleContent) {
        this.heading.getChildren().setAll((Object[])titleContent);
    }

    public ObservableList<Node> getBody() {
        return this.body.getChildren();
    }

    public void setBody(Node ... body) {
        this.body.getChildren().setAll((Object[])body);
    }

    public ObservableList<Node> getActions() {
        return this.actions.getChildren();
    }

    public void setActions(Node ... actions) {
        this.actions.getChildren().setAll((Object[])actions);
    }

    public void setActions(List<? extends Node> actions) {
        this.actions.getChildren().setAll(actions);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPadding(new Insets(24.0, 24.0, 16.0, 24.0));
        this.setStyle("-fx-text-fill: rgba(0, 0, 0, 0.87);");
        this.heading.setStyle("-fx-font-weight: BOLD;-fx-alignment: center-left;");
        this.heading.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.body.setStyle("-fx-pref-width: 400px;-fx-wrap-text: true;");
        this.actions.setStyle("-fx-alignment: center-right ;");
        this.actions.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
    }
}

