/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXNodesList$$Lambda$1;
import com.jfoenix.controls.JFXNodesList$$Lambda$2;
import com.jfoenix.controls.JFXNodesList$$Lambda$3;
import com.jfoenix.controls.JFXNodesList$$Lambda$4;
import com.jfoenix.controls.JFXNodesList$$Lambda$5;
import com.jfoenix.controls.JFXNodesList$$Lambda$6;
import com.jfoenix.controls.JFXNodesList$$Lambda$7;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;

public class JFXNodesList
extends VBox {
    private final HashMap<Node, Callback<Boolean, Collection<KeyValue>>> animationsMap = new HashMap();
    private boolean expanded = false;
    private final Timeline animateTimeline = new Timeline();

    public JFXNodesList() {
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-nodes-list");
    }

    public void addAnimatedNode(Region node) {
        this.addAnimatedNode(node, null);
    }

    public void addAnimatedNode(Region node, Callback<Boolean, Collection<KeyValue>> animationCallBack) {
        if (node instanceof JFXNodesList) {
            StackPane container = new StackPane(new Node[]{node});
            container.setPickOnBounds(false);
            this.addAnimatedNode((Region)container, animationCallBack);
            return;
        }
        node.setVisible(false);
        if (this.getChildren().size() > 0) {
            this.initNode((Node)node);
        } else {
            if (node instanceof Button) {
                ((Button)node).setOnAction(JFXNodesList$$Lambda$1.lambdaFactory$(this));
            } else {
                node.setOnMouseClicked(JFXNodesList$$Lambda$2.lambdaFactory$(this));
            }
            node.getStyleClass().add((Object)"trigger-node");
            node.setVisible(true);
        }
        this.getChildren().add((Object)node);
        this.rotateProperty().addListener(JFXNodesList$$Lambda$3.lambdaFactory$(node));
        if (animationCallBack == null && this.getChildren().size() != 1) {
            animationCallBack = JFXNodesList$$Lambda$4.lambdaFactory$(this, node);
        } else if (animationCallBack == null && this.getChildren().size() == 1) {
            animationCallBack = JFXNodesList$$Lambda$5.lambdaFactory$();
        }
        this.animationsMap.put((Node)node, animationCallBack);
    }

    protected double computePrefWidth(double height) {
        if (!this.getChildren().isEmpty()) {
            return ((Node)this.getChildren().get(0)).prefWidth(height);
        }
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        if (!this.getChildren().isEmpty()) {
            return ((Node)this.getChildren().get(0)).prefHeight(width);
        }
        return super.computePrefHeight(width);
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return this.computePrefWidth(height);
    }

    public void animateList() {
        boolean bl = this.expanded = !this.expanded;
        if (this.animateTimeline.getStatus() == Animation.Status.RUNNING) {
            this.animateTimeline.stop();
        }
        this.animateTimeline.getKeyFrames().clear();
        double duration = 120.0 / (double)this.getChildren().size();
        if (this.expanded) {
            this.getChildren().forEach(JFXNodesList$$Lambda$6.lambdaFactory$());
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            Node child = (Node)this.getChildren().get(i);
            Collection keyValues = (Collection)this.animationsMap.get(child).call((Object)this.expanded);
            this.animateTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)((double)i * duration)), keyValues.toArray(new KeyValue[keyValues.size()])));
        }
        Collection keyValues = (Collection)this.animationsMap.get(this.getChildren().get(0)).call((Object)this.expanded);
        this.animateTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)160.0), keyValues.toArray(new KeyValue[keyValues.size()])));
        if (!this.expanded) {
            this.animateTimeline.setOnFinished(JFXNodesList$$Lambda$7.lambdaFactory$(this));
        } else {
            this.animateTimeline.setOnFinished(null);
        }
        this.animateTimeline.play();
    }

    protected void initNode(Node node) {
        node.setScaleX(0.0);
        node.setScaleY(0.0);
        node.getStyleClass().add((Object)"sub-node");
    }

    private ArrayList<KeyValue> initDefaultAnimation(Region region, boolean expanded) {
        ArrayList<KeyValue> defaultAnimationValues = new ArrayList<KeyValue>();
        defaultAnimationValues.add(new KeyValue((WritableValue)region.scaleXProperty(), (Object)(expanded ? 1 : 0), Interpolator.EASE_BOTH));
        defaultAnimationValues.add(new KeyValue((WritableValue)region.scaleYProperty(), (Object)(expanded ? 1 : 0), Interpolator.EASE_BOTH));
        return defaultAnimationValues;
    }

    static /* synthetic */ void lambda$animateList$6(JFXNodesList this_, ActionEvent finish) {
        for (int i = 1; i < this_.getChildren().size(); ++i) {
            ((Node)this_.getChildren().get(i)).setVisible(false);
        }
    }

    static /* synthetic */ void lambda$animateList$5(Node child) {
        child.setVisible(true);
    }

    static /* synthetic */ Collection lambda$addAnimatedNode$4(Boolean expanded) {
        return new ArrayList();
    }

    static /* synthetic */ Collection lambda$addAnimatedNode$3(JFXNodesList this_, Region node, Boolean expanded) {
        return this_.initDefaultAnimation(node, expanded);
    }

    static /* synthetic */ void lambda$addAnimatedNode$2(Region node, ObservableValue o, Number oldVal, Number newVal) {
        node.setRotate(newVal.doubleValue() % 180.0 == 0.0 ? newVal.doubleValue() : -newVal.doubleValue());
    }

    static /* synthetic */ void lambda$addAnimatedNode$1(JFXNodesList this_, MouseEvent click) {
        this_.animateList();
    }

    static /* synthetic */ void lambda$addAnimatedNode$0(JFXNodesList this_, ActionEvent action) {
        this_.animateList();
    }
}

