/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.CacheMomento;
import com.jfoenix.transitions.JFXAnimationTimer$$Lambda$1;
import com.jfoenix.transitions.JFXAnimationTimer$$Lambda$2;
import com.jfoenix.transitions.JFXAnimationTimer$$Lambda$3;
import com.jfoenix.transitions.JFXAnimationTimer$AnimationHandler$$Lambda$1;
import com.jfoenix.transitions.JFXAnimationTimer$AnimationHandler$$Lambda$2;
import com.jfoenix.transitions.JFXAnimationTimer$AnimationHandler$$Lambda$3;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.animation.AnimationTimer;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;

public class JFXAnimationTimer
extends AnimationTimer {
    private Set<AnimationHandler> animationHandlers = new HashSet<AnimationHandler>();
    private HashMap<WritableValue<?>, Object> initialValuesMap = new HashMap();
    private long startTime = -1L;
    private boolean running = false;
    private List<CacheMomento> caches = new ArrayList<CacheMomento>();

    public JFXAnimationTimer(JFXKeyFrame ... keyFrames) {
        for (JFXKeyFrame keyFrame : keyFrames) {
            Duration duration = keyFrame.getTime();
            Set<JFXKeyValue> keyValuesSet = keyFrame.getValues();
            if (keyValuesSet.isEmpty()) continue;
            this.animationHandlers.add(new AnimationHandler(duration, keyFrame.getValues()));
        }
    }

    public void start() {
        super.start();
        this.running = true;
        this.startTime = -1L;
        this.animationHandlers.forEach(JFXAnimationTimer$$Lambda$1.lambdaFactory$());
        this.caches.forEach(JFXAnimationTimer$$Lambda$2.lambdaFactory$());
    }

    public void handle(long now) {
        this.startTime = this.startTime == -1L ? now : this.startTime;
        double totalElapsedMilliseconds = (double)(now - this.startTime) / 1000000.0;
        boolean stop = true;
        for (AnimationHandler handler : this.animationHandlers) {
            handler.animate(totalElapsedMilliseconds);
            if (handler.finished) continue;
            stop = false;
        }
        if (stop) {
            this.stop();
        }
    }

    public void stop() {
        super.stop();
        this.running = false;
        this.initialValuesMap.clear();
        this.caches.forEach(JFXAnimationTimer$$Lambda$3.lambdaFactory$());
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setCacheNodes(Node ... nodesToCache) {
        this.caches.clear();
        if (nodesToCache != null) {
            for (Node node : nodesToCache) {
                this.caches.add(new CacheMomento(node));
            }
        }
    }

    class AnimationHandler {
        double duration;
        Set<JFXKeyValue> keyValues;
        boolean finished = false;

        public AnimationHandler(Duration duration, Set<JFXKeyValue> keyValues) {
            this.duration = duration.toMillis();
            this.keyValues = keyValues;
        }

        public void init() {
            this.finished = false;
            this.keyValues.forEach(JFXAnimationTimer$AnimationHandler$$Lambda$1.lambdaFactory$(this));
        }

        public void animate(double now) {
            if (now <= this.duration) {
                this.keyValues.forEach(JFXAnimationTimer$AnimationHandler$$Lambda$2.lambdaFactory$(this, now));
            } else if (!this.finished) {
                this.finished = true;
                this.keyValues.forEach(JFXAnimationTimer$AnimationHandler$$Lambda$3.lambdaFactory$());
            }
        }

        static /* synthetic */ void lambda$animate$2(JFXKeyValue keyValue) {
            WritableValue<?> target;
            if (keyValue.isValid() && (target = keyValue.getTarget()) != null) {
                target.setValue(keyValue.getEndValue());
            }
        }

        static /* synthetic */ void lambda$animate$1(AnimationHandler this_, double now, JFXKeyValue keyValue) {
            WritableValue<?> target;
            if (keyValue.isValid() && (target = keyValue.getTarget()) != null && !target.getValue().equals(keyValue.getEndValue())) {
                target.setValue(keyValue.getInterpolator().interpolate(this_.JFXAnimationTimer.this.initialValuesMap.get(target), keyValue.getEndValue(), now / this_.duration));
            }
        }

        static /* synthetic */ void lambda$init$0(AnimationHandler this_, JFXKeyValue keyValue) {
            if (keyValue.getTarget() != null) {
                this_.JFXAnimationTimer.this.initialValuesMap.putIfAbsent(keyValue.getTarget(), keyValue.getTarget().getValue());
            }
        }
    }
}

