/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dyn4j.BinarySearchTreeNode;
import org.dyn4j.resources.Messages;

final class BinarySearchTreeIterator<E extends Comparable<E>>
implements Iterator<E> {
    final Deque<BinarySearchTreeNode<E>> stack;
    final boolean inOrder;

    public BinarySearchTreeIterator(BinarySearchTreeNode<E> node) {
        this(node, true);
    }

    public BinarySearchTreeIterator(BinarySearchTreeNode<E> node, boolean inOrder) {
        if (node == null) {
            throw new NullPointerException(Messages.getString("binarySearchTree.nullSubTreeForIterator"));
        }
        this.inOrder = inOrder;
        this.stack = new ArrayDeque<BinarySearchTreeNode<E>>();
        if (inOrder) {
            this.pushLeft(node);
        } else {
            this.pushRight(node);
        }
    }

    protected void pushLeft(BinarySearchTreeNode<E> node) {
        while (node != null) {
            this.stack.push(node);
            node = node.left;
        }
    }

    protected void pushRight(BinarySearchTreeNode<E> node) {
        while (node != null) {
            this.stack.push(node);
            node = node.right;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public E next() {
        if (this.stack.isEmpty()) {
            throw new NoSuchElementException();
        }
        BinarySearchTreeNode<E> node = this.stack.pop();
        if (this.inOrder) {
            this.pushLeft(node.right);
        } else {
            this.pushRight(node.left);
        }
        return node.comparable;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

