/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j;

import org.dyn4j.resources.Messages;

final class BinarySearchTreeNode<E extends Comparable<E>>
implements Comparable<BinarySearchTreeNode<E>> {
    final E comparable;
    BinarySearchTreeNode<E> parent;
    BinarySearchTreeNode<E> left;
    BinarySearchTreeNode<E> right;

    public BinarySearchTreeNode(E comparable) {
        this(comparable, null, null, null);
    }

    public BinarySearchTreeNode(E comparable, BinarySearchTreeNode<E> parent, BinarySearchTreeNode<E> left, BinarySearchTreeNode<E> right) {
        if (comparable == null) {
            throw new NullPointerException(Messages.getString("binarySearchTree.nullComparable"));
        }
        this.comparable = comparable;
        this.parent = parent;
        this.left = left;
        this.right = right;
    }

    public String toString() {
        return this.comparable.toString();
    }

    @Override
    public int compareTo(BinarySearchTreeNode<E> other) {
        return this.comparable.compareTo(other.comparable);
    }

    public E getComparable() {
        return this.comparable;
    }

    boolean isLeftChild() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.left == this;
    }
}

