/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dyn4j.DataContainer;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;
import org.dyn4j.collision.FixtureIterator;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;

public abstract class AbstractCollidable<T extends Fixture>
implements Collidable<T>,
Transformable,
DataContainer {
    protected final UUID id;
    protected Transform transform;
    protected List<T> fixtures;
    protected double radius;
    protected Object userData;

    public AbstractCollidable() {
        this(1);
    }

    public AbstractCollidable(int fixtureCount) {
        int size = fixtureCount <= 0 ? 1 : fixtureCount;
        this.id = UUID.randomUUID();
        this.fixtures = new ArrayList<T>(size);
        this.radius = 0.0;
        this.transform = new Transform();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractCollidable) {
            return this.id.equals(((AbstractCollidable)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean removeFixture(T fixture) {
        if (fixture == null) {
            return false;
        }
        int size = this.fixtures.size();
        if (size > 0) {
            return this.fixtures.remove(fixture);
        }
        return false;
    }

    @Override
    public T removeFixture(int index) {
        return (T)((Fixture)this.fixtures.remove(index));
    }

    @Override
    public List<T> removeAllFixtures() {
        List<T> fixtures = this.fixtures;
        this.fixtures = new ArrayList<T>(fixtures.size());
        return fixtures;
    }

    @Override
    public boolean containsFixture(T fixture) {
        if (fixture == null) {
            return false;
        }
        return this.fixtures.contains(fixture);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void rotate(double theta, Vector2 point) {
        this.transform.rotate(theta, point);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotateAboutCenter(double theta) {
        Vector2 center = this.getWorldCenter();
        this.rotate(theta, center);
    }

    @Override
    public void translate(double x, double y) {
        this.transform.translate(x, y);
    }

    @Override
    public void translate(Vector2 vector) {
        this.transform.translate(vector);
    }

    @Override
    public void translateToOrigin() {
        Vector2 wc = this.getWorldCenter();
        this.transform.translate(-wc.x, -wc.y);
    }

    @Override
    public void shift(Vector2 shift) {
        this.transform.translate(shift);
    }

    @Override
    public T getFixture(int index) {
        return (T)((Fixture)this.fixtures.get(index));
    }

    @Override
    public T getFixture(Vector2 point) {
        int size = this.fixtures.size();
        int i = 0;
        while (i < size) {
            Fixture fixture = (Fixture)this.fixtures.get(i);
            Convex convex = fixture.getShape();
            if (convex.contains(point, this.transform)) {
                return (T)fixture;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<T> getFixtures(Vector2 point) {
        ArrayList<Fixture> fixtures = new ArrayList<Fixture>();
        int size = this.fixtures.size();
        int i = 0;
        while (i < size) {
            Fixture fixture = (Fixture)this.fixtures.get(i);
            Convex convex = fixture.getShape();
            if (convex.contains(point, this.transform)) {
                fixtures.add(fixture);
            }
            ++i;
        }
        return fixtures;
    }

    @Override
    public T removeFixture(Vector2 point) {
        int size = this.fixtures.size();
        int i = 0;
        while (i < size) {
            Fixture fixture = (Fixture)this.fixtures.get(i);
            Convex convex = fixture.getShape();
            if (convex.contains(point, this.transform)) {
                this.fixtures.remove(i);
                return (T)fixture;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<T> removeFixtures(Vector2 point) {
        ArrayList<Fixture> fixtures = new ArrayList<Fixture>();
        Iterator<T> it = this.fixtures.iterator();
        while (it.hasNext()) {
            Fixture fixture = (Fixture)it.next();
            Convex convex = fixture.getShape();
            if (!convex.contains(point, this.transform)) continue;
            it.remove();
            fixtures.add(fixture);
        }
        return fixtures;
    }

    @Override
    public int getFixtureCount() {
        return this.fixtures.size();
    }

    @Override
    public List<T> getFixtures() {
        return Collections.unmodifiableList(this.fixtures);
    }

    @Override
    public Iterator<T> getFixtureIterator() {
        return new FixtureIterator(this);
    }

    @Override
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public double getRotationDiscRadius() {
        return this.radius;
    }

    @Override
    public void setTransform(Transform transform) {
        if (transform == null) {
            return;
        }
        this.transform.set(transform);
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public AABB createAABB() {
        return this.createAABB(this.transform);
    }

    @Override
    public AABB createAABB(Transform transform) {
        int size = this.fixtures.size();
        if (size > 0) {
            AABB aabb = ((Fixture)this.fixtures.get(0)).getShape().createAABB(transform);
            int i = 1;
            while (i < size) {
                AABB faabb = ((Fixture)this.fixtures.get(i)).getShape().createAABB(transform);
                aabb.union(faabb);
                ++i;
            }
            return aabb;
        }
        return new AABB(new Vector2(0.0, 0.0), new Vector2(0.0, 0.0));
    }

    @Override
    public Vector2 getLocalPoint(Vector2 worldPoint) {
        return this.transform.getInverseTransformed(worldPoint);
    }

    @Override
    public Vector2 getWorldPoint(Vector2 localPoint) {
        return this.transform.getTransformed(localPoint);
    }

    @Override
    public Vector2 getLocalVector(Vector2 worldVector) {
        return this.transform.getInverseTransformedR(worldVector);
    }

    @Override
    public Vector2 getWorldVector(Vector2 localVector) {
        return this.transform.getTransformedR(localVector);
    }

    @Override
    public boolean contains(Vector2 point) {
        int size = this.fixtures.size();
        int i = 0;
        while (i < size) {
            Fixture fixture = (Fixture)this.fixtures.get(i);
            Convex convex = fixture.getShape();
            if (convex.contains(point, this.transform)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

