/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;

final class FixtureIterator<T extends Fixture>
implements Iterator<T> {
    private final Collidable<T> collidable;
    private int index;

    public FixtureIterator(Collidable<T> collidable) {
        this.collidable = collidable;
        this.index = -1;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.collidable.getFixtureCount();
    }

    @Override
    public T next() {
        if (this.index >= this.collidable.getFixtureCount()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            ++this.index;
            T fixture = this.collidable.getFixture(this.index);
            return fixture;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        if (this.index < 0) {
            throw new IllegalStateException();
        }
        if (this.index >= this.collidable.getFixtureCount()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.collidable.removeFixture(this.index);
            --this.index;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }
}

