/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;

public final class BroadphasePair<E extends Collidable<T>, T extends Fixture> {
    final E collidable1;
    final T fixture1;
    final E collidable2;
    final T fixture2;

    public BroadphasePair(E collidable1, T fixture1, E collidable2, T fixture2) {
        this.collidable1 = collidable1;
        this.fixture1 = fixture1;
        this.collidable2 = collidable2;
        this.fixture2 = fixture2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BroadphasePair) {
            BroadphasePair pair = (BroadphasePair)obj;
            if (pair.collidable1 == this.collidable1 && pair.fixture1 == this.fixture1 && pair.collidable2 == this.collidable2 && pair.fixture2 == this.fixture2) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.collidable1.hashCode();
        hash = hash * 31 + ((Fixture)this.fixture1).hashCode();
        hash = hash * 31 + this.collidable2.hashCode();
        hash = hash * 31 + ((Fixture)this.fixture2).hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BroadphasePair[Collidable1=").append(this.collidable1.getId()).append("|Fixture1=").append(((Fixture)this.fixture1).getId()).append("|Collidable2=").append(this.collidable2.getId()).append("|Fixture2=").append(((Fixture)this.fixture2).getId()).append("]");
        return sb.toString();
    }

    public E getCollidable1() {
        return this.collidable1;
    }

    public T getFixture1() {
        return this.fixture1;
    }

    public E getCollidable2() {
        return this.collidable2;
    }

    public T getFixture2() {
        return this.fixture2;
    }
}

