/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.Fixture;
import org.dyn4j.collision.broadphase.AbstractBroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphaseFilter;
import org.dyn4j.collision.broadphase.BroadphaseItem;
import org.dyn4j.collision.broadphase.BroadphaseKey;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.collision.broadphase.DynamicAABBTreeLeaf;
import org.dyn4j.collision.broadphase.DynamicAABBTreeNode;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class DynamicAABBTree<E extends Collidable<T>, T extends Fixture>
extends AbstractBroadphaseDetector<E, T>
implements BroadphaseDetector<E, T> {
    DynamicAABBTreeNode root;
    final Map<BroadphaseKey, DynamicAABBTreeLeaf<E, T>> map;

    public DynamicAABBTree() {
        this(64);
    }

    public DynamicAABBTree(int initialCapacity) {
        this.map = new LinkedHashMap<BroadphaseKey, DynamicAABBTreeLeaf<E, T>>(initialCapacity * 4 / 3 + 1, 0.75f);
    }

    @Override
    public void add(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        DynamicAABBTreeLeaf<E, T> node = this.map.get(key);
        if (node != null) {
            this.update(key, node, collidable, fixture);
        } else {
            this.add(key, collidable, fixture);
        }
    }

    void add(BroadphaseKey key, E collidable, T fixture) {
        Transform tx = collidable.getTransform();
        AABB aabb = ((Fixture)fixture).getShape().createAABB(tx);
        aabb.expand(this.expansion);
        DynamicAABBTreeLeaf<E, T> node = new DynamicAABBTreeLeaf<E, T>(collidable, fixture);
        node.aabb = aabb;
        this.map.put(key, node);
        this.insert(node);
    }

    @Override
    public boolean remove(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        DynamicAABBTreeLeaf<E, T> node = this.map.remove(key);
        if (node != null) {
            this.remove(node);
            return true;
        }
        return false;
    }

    @Override
    public void update(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        DynamicAABBTreeLeaf<E, T> node = this.map.get(key);
        if (node != null) {
            this.update(key, node, collidable, fixture);
        } else {
            this.add(key, collidable, fixture);
        }
    }

    void update(BroadphaseKey key, DynamicAABBTreeLeaf<E, T> node, E collidable, T fixture) {
        Transform tx = collidable.getTransform();
        AABB aabb = ((Fixture)fixture).getShape().createAABB(tx);
        if (node.aabb.contains(aabb)) {
            return;
        }
        aabb.expand(this.expansion);
        this.remove(node);
        node.aabb = aabb;
        this.insert(node);
    }

    @Override
    public AABB getAABB(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        DynamicAABBTreeLeaf<E, T> node = this.map.get(key);
        if (node != null) {
            return node.aabb;
        }
        return ((Fixture)fixture).getShape().createAABB(collidable.getTransform());
    }

    @Override
    public boolean contains(E collidable) {
        int size = collidable.getFixtureCount();
        boolean result = true;
        int i = 0;
        while (i < size) {
            Object fixture = collidable.getFixture(i);
            BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
            result &= this.map.containsKey(key);
            ++i;
        }
        return result;
    }

    @Override
    public boolean contains(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.root = null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public List<BroadphasePair<E, T>> detect(BroadphaseFilter<E, T> filter) {
        int size = this.map.size();
        Collection<DynamicAABBTreeLeaf<E, T>> nodes = this.map.values();
        for (DynamicAABBTreeLeaf<E, T> node : nodes) {
            node.tested = false;
        }
        int eSize = Collisions.getEstimatedCollisionPairs(size);
        ArrayList<BroadphasePair<E, T>> pairs = new ArrayList<BroadphasePair<E, T>>(eSize);
        for (DynamicAABBTreeLeaf<E, T> node : nodes) {
            this.detectNonRecursive(node, this.root, filter, pairs);
            node.tested = true;
        }
        return pairs;
    }

    @Override
    public List<BroadphaseItem<E, T>> detect(AABB aabb, BroadphaseFilter<E, T> filter) {
        return this.detectNonRecursive(aabb, this.root, filter);
    }

    @Override
    public List<BroadphaseItem<E, T>> raycast(Ray ray, double length, BroadphaseFilter<E, T> filter) {
        if (this.map.size() == 0) {
            return Collections.emptyList();
        }
        Vector2 s = ray.getStart();
        Vector2 d = ray.getDirectionVector();
        double l = length;
        if (length <= 0.0) {
            l = Double.MAX_VALUE;
        }
        double x1 = s.x;
        double x2 = s.x + d.x * l;
        double y1 = s.y;
        double y2 = s.y + d.y * l;
        Vector2 min = new Vector2(Math.min(x1, x2), Math.min(y1, y2));
        Vector2 max = new Vector2(Math.max(x1, x2), Math.max(y1, y2));
        AABB aabb = new AABB(min, max);
        double invDx = 1.0 / d.x;
        double invDy = 1.0 / d.y;
        DynamicAABBTreeNode node = this.root;
        int eSize = Collisions.getEstimatedRaycastCollisions(this.map.size());
        ArrayList list = new ArrayList(eSize);
        while (node != null) {
            if (aabb.overlaps(node.aabb)) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                if (this.raycast(s, l, invDx, invDy, node.aabb)) {
                    DynamicAABBTreeLeaf leaf = (DynamicAABBTreeLeaf)node;
                    if (filter.isAllowed(ray, length, leaf.collidable, leaf.fixture)) {
                        list.add(new BroadphaseItem(leaf.collidable, leaf.fixture));
                    }
                }
            }
            boolean nextNodeFound = false;
            while (node.parent != null) {
                if (node == node.parent.left) {
                    node = node.parent.right;
                    nextNodeFound = true;
                    break;
                }
                node = node.parent;
            }
            if (!nextNodeFound) break;
        }
        return list;
    }

    @Override
    public void shift(Vector2 shift) {
        DynamicAABBTreeNode node = this.root;
        while (node != null) {
            if (node.left != null) {
                node = node.left;
                continue;
            }
            if (node.right != null) {
                node.aabb.translate(shift);
                node = node.right;
                continue;
            }
            node.aabb.translate(shift);
            boolean nextNodeFound = false;
            while (node.parent != null) {
                if (node == node.parent.left && node.parent.right != null) {
                    node.parent.aabb.translate(shift);
                    node = node.parent.right;
                    nextNodeFound = true;
                    break;
                }
                node = node.parent;
            }
            if (!nextNodeFound) break;
        }
    }

    void detect(DynamicAABBTreeLeaf<E, T> node, DynamicAABBTreeNode root, BroadphaseFilter<E, T> filter, List<BroadphasePair<E, T>> pairs) {
        if (node.aabb.overlaps(root.aabb)) {
            if (root.left == null) {
                DynamicAABBTreeLeaf leaf = (DynamicAABBTreeLeaf)root;
                if (!leaf.tested && leaf.collidable != node.collidable && filter.isAllowed(node.collidable, node.fixture, leaf.collidable, leaf.fixture)) {
                    BroadphasePair pair = new BroadphasePair(node.collidable, node.fixture, leaf.collidable, leaf.fixture);
                    pairs.add(pair);
                }
                return;
            }
            if (root.left != null) {
                this.detect(node, root.left, filter, pairs);
            }
            if (root.right != null) {
                this.detect(node, root.right, filter, pairs);
            }
        }
    }

    void detectNonRecursive(DynamicAABBTreeLeaf<E, T> node, DynamicAABBTreeNode root, BroadphaseFilter<E, T> filter, List<BroadphasePair<E, T>> pairs) {
        DynamicAABBTreeNode test = root;
        while (test != null) {
            if (test.aabb.overlaps(node.aabb)) {
                if (test.left != null) {
                    test = test.left;
                    continue;
                }
                DynamicAABBTreeLeaf leaf = (DynamicAABBTreeLeaf)test;
                if (!leaf.tested && leaf.collidable != node.collidable && filter.isAllowed(node.collidable, node.fixture, leaf.collidable, leaf.fixture)) {
                    BroadphasePair pair = new BroadphasePair(node.collidable, node.fixture, leaf.collidable, leaf.fixture);
                    pairs.add(pair);
                }
            }
            boolean nextNodeFound = false;
            while (test.parent != null) {
                if (test == test.parent.left) {
                    test = test.parent.right;
                    nextNodeFound = true;
                    break;
                }
                test = test.parent;
            }
            if (!nextNodeFound) break;
        }
    }

    void detect(AABB aabb, DynamicAABBTreeNode node, BroadphaseFilter<E, T> filter, List<BroadphaseItem<E, T>> list) {
        if (aabb.overlaps(node.aabb)) {
            if (node.left == null) {
                DynamicAABBTreeLeaf leaf = (DynamicAABBTreeLeaf)node;
                if (filter.isAllowed(aabb, leaf.collidable, leaf.fixture)) {
                    list.add(new BroadphaseItem(leaf.collidable, leaf.fixture));
                }
                return;
            }
            if (node.left != null) {
                this.detect(aabb, node.left, filter, list);
            }
            if (node.right != null) {
                this.detect(aabb, node.right, filter, list);
            }
        }
    }

    List<BroadphaseItem<E, T>> detectNonRecursive(AABB aabb, DynamicAABBTreeNode node, BroadphaseFilter<E, T> filter) {
        int eSize = Collisions.getEstimatedCollisionsPerObject();
        ArrayList list = new ArrayList(eSize);
        while (node != null) {
            if (aabb.overlaps(node.aabb)) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                DynamicAABBTreeLeaf leaf = (DynamicAABBTreeLeaf)node;
                if (filter.isAllowed(aabb, leaf.collidable, leaf.fixture)) {
                    list.add(new BroadphaseItem(leaf.collidable, leaf.fixture));
                }
            }
            boolean nextNodeFound = false;
            while (node.parent != null) {
                if (node == node.parent.left) {
                    node = node.parent.right;
                    nextNodeFound = true;
                    break;
                }
                node = node.parent;
            }
            if (!nextNodeFound) break;
        }
        return list;
    }

    void insert(DynamicAABBTreeNode item) {
        if (this.root == null) {
            this.root = item;
            return;
        }
        AABB itemAABB = item.aabb;
        DynamicAABBTreeNode node = this.root;
        while (!node.isLeaf()) {
            AABB u;
            AABB u2;
            AABB aabb = node.aabb;
            double perimeter = aabb.getPerimeter();
            AABB union = aabb.getUnion(itemAABB);
            double unionPerimeter = union.getPerimeter();
            double cost = 2.0 * unionPerimeter;
            double descendCost = 2.0 * (unionPerimeter - perimeter);
            DynamicAABBTreeNode left = node.left;
            DynamicAABBTreeNode right = node.right;
            double costl = 0.0;
            if (left.isLeaf()) {
                u2 = left.aabb.getUnion(itemAABB);
                costl = u2.getPerimeter() + descendCost;
            } else {
                u2 = left.aabb.getUnion(itemAABB);
                double oldPerimeter = left.aabb.getPerimeter();
                double newPerimeter = u2.getPerimeter();
                costl = newPerimeter - oldPerimeter + descendCost;
            }
            double costr = 0.0;
            if (right.isLeaf()) {
                u = right.aabb.getUnion(itemAABB);
                costr = u.getPerimeter() + descendCost;
            } else {
                u = right.aabb.getUnion(itemAABB);
                double oldPerimeter = right.aabb.getPerimeter();
                double newPerimeter = u.getPerimeter();
                costr = newPerimeter - oldPerimeter + descendCost;
            }
            if (cost < costl && cost < costr) break;
            node = costl < costr ? left : right;
        }
        DynamicAABBTreeNode parent = node.parent;
        DynamicAABBTreeNode newParent = new DynamicAABBTreeNode();
        newParent.parent = node.parent;
        newParent.aabb = node.aabb.getUnion(itemAABB);
        newParent.height = node.height + 1;
        if (parent != null) {
            if (parent.left == node) {
                parent.left = newParent;
            } else {
                parent.right = newParent;
            }
            newParent.left = node;
            newParent.right = item;
            node.parent = newParent;
            item.parent = newParent;
        } else {
            newParent.left = node;
            newParent.right = item;
            node.parent = newParent;
            item.parent = newParent;
            this.root = newParent;
        }
        node = item.parent;
        while (node != null) {
            node = this.balance(node);
            DynamicAABBTreeNode left = node.left;
            DynamicAABBTreeNode right = node.right;
            node.height = 1 + Math.max(left.height, right.height);
            node.aabb = left.aabb.getUnion(right.aabb);
            node = node.parent;
        }
    }

    @Override
    void remove(DynamicAABBTreeNode node) {
        if (this.root == null) {
            return;
        }
        if (node == this.root) {
            this.root = null;
            return;
        }
        DynamicAABBTreeNode parent = node.parent;
        DynamicAABBTreeNode grandparent = parent.parent;
        DynamicAABBTreeNode other = parent.left == node ? parent.right : parent.left;
        if (grandparent != null) {
            if (grandparent.left == parent) {
                grandparent.left = other;
            } else {
                grandparent.right = other;
            }
            other.parent = grandparent;
            DynamicAABBTreeNode n = grandparent;
            while (n != null) {
                n = this.balance(n);
                DynamicAABBTreeNode left = n.left;
                DynamicAABBTreeNode right = n.right;
                n.height = 1 + Math.max(left.height, right.height);
                n.aabb = left.aabb.getUnion(right.aabb);
                n = n.parent;
            }
        } else {
            this.root = other;
            other.parent = null;
        }
    }

    DynamicAABBTreeNode balance(DynamicAABBTreeNode node) {
        DynamicAABBTreeNode a = node;
        if (a.isLeaf() || a.height < 2) {
            return a;
        }
        DynamicAABBTreeNode b = a.left;
        DynamicAABBTreeNode c = a.right;
        int balance = c.height - b.height;
        if (balance > 1) {
            DynamicAABBTreeNode f = c.left;
            DynamicAABBTreeNode g = c.right;
            c.left = a;
            c.parent = a.parent;
            a.parent = c;
            if (c.parent != null) {
                if (c.parent.left == a) {
                    c.parent.left = c;
                } else {
                    c.parent.right = c;
                }
            } else {
                this.root = c;
            }
            if (f.height > g.height) {
                c.right = f;
                a.right = g;
                g.parent = a;
                a.aabb = b.aabb.getUnion(g.aabb);
                c.aabb = a.aabb.getUnion(f.aabb);
                a.height = 1 + Math.max(b.height, g.height);
                c.height = 1 + Math.max(a.height, f.height);
            } else {
                c.right = g;
                a.right = f;
                f.parent = a;
                a.aabb = b.aabb.getUnion(f.aabb);
                c.aabb = a.aabb.getUnion(g.aabb);
                a.height = 1 + Math.max(b.height, f.height);
                c.height = 1 + Math.max(a.height, g.height);
            }
            return c;
        }
        if (balance < -1) {
            DynamicAABBTreeNode d = b.left;
            DynamicAABBTreeNode e = b.right;
            b.left = a;
            b.parent = a.parent;
            a.parent = b;
            if (b.parent != null) {
                if (b.parent.left == a) {
                    b.parent.left = b;
                } else {
                    b.parent.right = b;
                }
            } else {
                this.root = b;
            }
            if (d.height > e.height) {
                b.right = d;
                a.left = e;
                e.parent = a;
                a.aabb = c.aabb.getUnion(e.aabb);
                b.aabb = a.aabb.getUnion(d.aabb);
                a.height = 1 + Math.max(c.height, e.height);
                b.height = 1 + Math.max(a.height, d.height);
            } else {
                b.right = e;
                a.left = d;
                d.parent = a;
                a.aabb = c.aabb.getUnion(d.aabb);
                b.aabb = a.aabb.getUnion(e.aabb);
                a.height = 1 + Math.max(c.height, d.height);
                b.height = 1 + Math.max(a.height, e.height);
            }
            return b;
        }
        return a;
    }

    void validate(DynamicAABBTreeNode node) {
        if (node == null) {
            return;
        }
        if (node == this.root) assert (node.parent == null);
        DynamicAABBTreeNode left = node.left;
        DynamicAABBTreeNode right = node.right;
        if (node.isLeaf()) {
            DynamicAABBTreeLeaf leaf = (DynamicAABBTreeLeaf)node;
            assert (node.left == null);
            assert (node.right == null);
            assert (node.height == 0);
            assert (leaf.collidable != null);
            return;
        }
        assert (node.aabb.contains(left.aabb));
        if (right != null) assert (node.aabb.contains(right.aabb));
        assert (left.parent == node);
        assert (right.parent == node);
        this.validate(left);
        this.validate(right);
    }
}

