/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;
import org.dyn4j.geometry.AABB;

final class SapProxy<E extends Collidable<T>, T extends Fixture>
implements Comparable<SapProxy<E, T>> {
    final E collidable;
    final T fixture;
    AABB aabb;
    boolean tested;

    public SapProxy(E collidable, T fixture, AABB aabb) {
        this.collidable = collidable;
        this.fixture = fixture;
        this.aabb = aabb;
    }

    @Override
    public int compareTo(SapProxy<E, T> o) {
        if (this == o) {
            return 0;
        }
        double diff = this.aabb.getMinX() - o.aabb.getMinX();
        if (diff != 0.0) {
            return (int)Math.signum(diff);
        }
        diff = this.aabb.getMinY() - o.aabb.getMinY();
        if (diff != 0.0) {
            return (int)Math.signum(diff);
        }
        if (this.isSearch()) {
            return -1;
        }
        if (o.isSearch()) {
            return 1;
        }
        diff = this.collidable.getId().compareTo(o.collidable.getId());
        if (diff == 0.0) {
            return ((Fixture)this.fixture).getId().compareTo(((Fixture)o.fixture).getId());
        }
        return (int)Math.signum(diff);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SapProxy) {
            SapProxy pair = (SapProxy)obj;
            if (pair.collidable == this.collidable && pair.fixture == this.fixture) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.collidable.hashCode();
        hash = hash * 31 + ((Fixture)this.fixture).hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SapProxy[Collidable=").append(this.collidable != null ? this.collidable.getId() : "null").append("|Fixture=").append(this.fixture != null ? ((Fixture)this.fixture).getId() : "null").append("|AABB=").append(this.aabb.toString()).append("|Tested=").append(this.tested).append("]");
        return sb.toString();
    }

    public final boolean isSearch() {
        return this.collidable == null || this.fixture == null;
    }
}

