/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.narrowphase.ExpandingSimplex;
import org.dyn4j.collision.narrowphase.ExpandingSimplexEdge;
import org.dyn4j.collision.narrowphase.MinkowskiPenetrationSolver;
import org.dyn4j.collision.narrowphase.MinkowskiSum;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Epa
implements MinkowskiPenetrationSolver {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    public static final double DEFAULT_DISTANCE_EPSILON = Math.sqrt(Epsilon.E);
    protected int maxIterations = 100;
    protected double distanceEpsilon = DEFAULT_DISTANCE_EPSILON;

    @Override
    public void getPenetration(List<Vector2> simplex, MinkowskiSum minkowskiSum, Penetration penetration) {
        ExpandingSimplex smplx = new ExpandingSimplex(simplex);
        ExpandingSimplexEdge edge = null;
        Vector2 point = null;
        int i = 0;
        while (i < this.maxIterations) {
            edge = smplx.getClosestEdge();
            point = minkowskiSum.getSupportPoint(edge.normal);
            double projection = point.dot(edge.normal);
            if (projection - edge.distance < this.distanceEpsilon) {
                penetration.normal = edge.normal;
                penetration.depth = projection;
                return;
            }
            smplx.expand(point);
            ++i;
        }
        penetration.normal = edge.normal;
        penetration.depth = point.dot(edge.normal);
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        if (maxIterations < 5) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.epa.invalidMaximumIterations"));
        }
        this.maxIterations = maxIterations;
    }

    public double getDistanceEpsilon() {
        return this.distanceEpsilon;
    }

    public void setDistanceEpsilon(double distanceEpsilon) {
        if (distanceEpsilon <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.epa.invalidDistanceEpsilon"));
        }
        this.distanceEpsilon = distanceEpsilon;
    }
}

