/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.List;
import java.util.PriorityQueue;
import org.dyn4j.collision.narrowphase.ExpandingSimplexEdge;
import org.dyn4j.geometry.Vector2;

final class ExpandingSimplex {
    private final int winding;
    private final PriorityQueue<ExpandingSimplexEdge> queue;

    public ExpandingSimplex(List<Vector2> simplex) {
        this.winding = this.getWinding(simplex);
        this.queue = new PriorityQueue();
        int size = simplex.size();
        int i = 0;
        while (i < size) {
            int j = i + 1 == size ? 0 : i + 1;
            Vector2 a = simplex.get(i);
            Vector2 b = simplex.get(j);
            this.queue.add(new ExpandingSimplexEdge(a, b, this.winding));
            ++i;
        }
    }

    protected final int getWinding(List<Vector2> simplex) {
        int size = simplex.size();
        int i = 0;
        while (i < size) {
            Vector2 b;
            int j = i + 1 == size ? 0 : i + 1;
            Vector2 a = simplex.get(i);
            if (a.cross(b = simplex.get(j)) > 0.0) {
                return 1;
            }
            if (a.cross(b) < 0.0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public final ExpandingSimplexEdge getClosestEdge() {
        return this.queue.peek();
    }

    public final void expand(Vector2 point) {
        ExpandingSimplexEdge edge = this.queue.poll();
        ExpandingSimplexEdge edge1 = new ExpandingSimplexEdge(edge.point1, point, this.winding);
        ExpandingSimplexEdge edge2 = new ExpandingSimplexEdge(point, edge.point2, this.winding);
        this.queue.add(edge1);
        this.queue.add(edge2);
    }
}

