/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.Epsilon;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public final class SegmentDetector {
    private SegmentDetector() {
    }

    public static boolean raycast(Ray ray, double maxLength, Segment segment, Transform transform, Raycast raycast) {
        Vector2 p0 = ray.getStart();
        Vector2 d0 = ray.getDirectionVector();
        Vector2 p1 = transform.getTransformed(segment.getPoint1());
        Vector2 p2 = transform.getTransformed(segment.getPoint2());
        Vector2 d1 = p1.to(p2);
        if (segment.contains(p0, transform)) {
            return false;
        }
        Vector2 p0ToP1 = p1.difference(p0);
        double num = d1.cross(p0ToP1);
        double den = d1.cross(d0);
        if (Math.abs(den) <= Epsilon.E) {
            double nDotP1;
            Vector2 n = d0.cross(1.0);
            double nDotP0 = n.dot(p0);
            if (Math.abs(nDotP0 - (nDotP1 = n.dot(p1))) < Epsilon.E) {
                double d0DotP0 = d0.dot(p0);
                double d0DotP1 = d0.dot(p1);
                double d0DotP2 = d0.dot(p2);
                if (d0DotP1 < 0.0 || d0DotP2 < 0.0) {
                    return false;
                }
                double d = 0.0;
                Vector2 p = null;
                if (d0DotP1 < d0DotP2) {
                    d = d0DotP1 - d0DotP0;
                    p = p1.copy();
                } else {
                    d = d0DotP2 - d0DotP0;
                    p = p2.copy();
                }
                if (maxLength > 0.0 && d > maxLength) {
                    return false;
                }
                raycast.distance = d;
                raycast.point = p;
                raycast.normal = d0.getNegative();
                return true;
            }
            return false;
        }
        double t = num / den;
        if (t < 0.0) {
            return false;
        }
        if (maxLength > 0.0 && t > maxLength) {
            return false;
        }
        double s = (t * d0.x + p0.x - p1.x) / d1.x;
        if (s < 0.0 || s > 1.0) {
            return false;
        }
        Vector2 p = d0.product(t).add(p0);
        Vector2 l = p1.to(p2);
        l.normalize();
        l.right();
        double lDotD = l.dot(d0);
        if (lDotD > 0.0) {
            l.negate();
        }
        raycast.point = p;
        raycast.normal = l;
        raycast.distance = t;
        return true;
    }
}

