/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class FrictionJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double maximumForce;
    protected double maximumTorque;
    private Matrix22 K;
    private double angularMass;
    private Vector2 linearImpulse;
    private double angularImpulse;

    public FrictionJoint(Body body1, Body body2, Vector2 anchor) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor);
        this.localAnchor2 = body2.getLocalPoint(anchor);
        this.K = new Matrix22();
        this.linearImpulse = new Vector2();
        this.angularImpulse = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FrictionJoint[").append(super.toString()).append("|Anchor=").append(this.getAnchor1()).append("|MaximumForce=").append(this.maximumForce).append("|MaximumTorque=").append(this.maximumTorque).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.K.m00 = invM1 + invM2 + r1.y * r1.y * invI1 + r2.y * r2.y * invI2;
        this.K.m10 = this.K.m01 = -invI1 * r1.x * r1.y - invI2 * r2.x * r2.y;
        this.K.m11 = invM1 + invM2 + r1.x * r1.x * invI1 + r2.x * r2.x * invI2;
        this.angularMass = invI1 + invI2;
        if (this.angularMass > Epsilon.E) {
            this.angularMass = 1.0 / this.angularMass;
        }
        this.linearImpulse.multiply(step.getDeltaTimeRatio());
        this.angularImpulse *= step.getDeltaTimeRatio();
        this.body1.getLinearVelocity().add(this.linearImpulse.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * (r1.cross(this.linearImpulse) + this.angularImpulse));
        this.body2.getLinearVelocity().subtract(this.linearImpulse.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * (r2.cross(this.linearImpulse) + this.angularImpulse));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        double C = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
        double impulse = this.angularMass * -C;
        double oldImpulse = this.angularImpulse;
        double maxImpulse = this.maximumTorque * step.getDeltaTime();
        this.angularImpulse = Interval.clamp(this.angularImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.angularImpulse - oldImpulse;
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * impulse);
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * impulse);
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
        Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
        Vector2 pivotV = v1.subtract(v2);
        Vector2 impulse2 = this.K.solve(pivotV.negate());
        Vector2 oldImpulse2 = this.linearImpulse.copy();
        this.linearImpulse.add(impulse2);
        double maxImpulse2 = this.maximumForce * step.getDeltaTime();
        if (this.linearImpulse.getMagnitudeSquared() > maxImpulse2 * maxImpulse2) {
            this.linearImpulse.normalize();
            this.linearImpulse.multiply(maxImpulse2);
        }
        impulse2 = this.linearImpulse.difference(oldImpulse2);
        this.body1.getLinearVelocity().add(impulse2.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(impulse2));
        this.body2.getLinearVelocity().subtract(impulse2.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(impulse2));
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return this.linearImpulse.product(invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return this.angularImpulse * invdt;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public double getMaximumTorque() {
        return this.maximumTorque;
    }

    public void setMaximumTorque(double maximumTorque) {
        if (maximumTorque < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumTorque"));
        }
        this.maximumTorque = maximumTorque;
    }

    public double getMaximumForce() {
        return this.maximumForce;
    }

    public void setMaximumForce(double maximumForce) {
        if (maximumForce < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumForce"));
        }
        this.maximumForce = maximumForce;
    }
}

