/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class HalfEllipse
extends AbstractShape
implements Convex,
Shape,
Transformable,
DataContainer {
    private static final double INERTIA_CONSTANT = 0.10975696064646573;
    final double width;
    final double height;
    final double halfWidth;
    final Vector2 localXAxis;
    final Vector2 ellipseCenter;
    final Vector2[] vertices;

    private HalfEllipse(boolean valid, double width, double height, Vector2 center, Vector2[] vertices) {
        super(center, center.distance(vertices[1]));
        this.width = width;
        this.height = height;
        this.halfWidth = width * 0.5;
        this.ellipseCenter = new Vector2();
        this.localXAxis = new Vector2(1.0, 0.0);
        this.vertices = vertices;
    }

    public HalfEllipse(double width, double height) {
        this(HalfEllipse.validate(width, height), width, height, new Vector2(0.0, 4.0 * height / (Math.PI * 3)), new Vector2[]{new Vector2(-width * 0.5, 0.0), new Vector2(width * 0.5, 0.0)});
    }

    private static final boolean validate(double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipse.invalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipse.invalidHeight"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HalfEllipse[").append(super.toString()).append("|Width=").append(this.width).append("|Height=").append(this.height).append("]");
        return sb.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.halfEllipse.satNotSupported"));
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.halfEllipse.satNotSupported"));
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        Vector2 localAxis = transform.getInverseTransformedR(vector);
        double r = this.getRotation();
        localAxis.rotate(-r);
        localAxis.x *= this.halfWidth;
        localAxis.y *= this.height;
        localAxis.normalize();
        Vector2 p = null;
        if (localAxis.y <= 0.0 && localAxis.x >= 0.0) {
            return transform.getTransformed(this.vertices[1]);
        }
        if (localAxis.y <= 0.0 && localAxis.x <= 0.0) {
            return transform.getTransformed(this.vertices[0]);
        }
        p = new Vector2(localAxis.x * this.halfWidth, localAxis.y * this.height);
        p.rotate(r);
        p.add(this.ellipseCenter);
        transform.transform(p);
        return p;
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector, Transform transform) {
        Vector2 localAxis = transform.getInverseTransformedR(vector);
        if (localAxis.getAngleBetween(this.localXAxis) < 0.0) {
            Vector2 point = this.getFarthestPoint(vector, transform);
            return new PointFeature(point);
        }
        return Segment.getFarthestFeature(this.vertices[0], this.vertices[1], vector, transform);
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        Vector2 p1 = this.getFarthestPoint(vector, transform);
        Vector2 p2 = this.getFarthestPoint(vector.getNegative(), transform);
        double d1 = p1.dot(vector);
        double d2 = p2.dot(vector);
        return new Interval(d2, d1);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval x = this.project(Vector2.X_AXIS, transform);
        Interval y = this.project(Vector2.Y_AXIS, transform);
        return new AABB(x.getMin(), y.getMin(), x.getMax(), y.getMax());
    }

    @Override
    public Mass createMass(double density) {
        double area = Math.PI * this.halfWidth * this.height;
        double m = area * density * 0.5;
        double I = m * (this.halfWidth * this.halfWidth + this.height * this.height) * 0.10975696064646573;
        return new Mass(this.center, m, I);
    }

    @Override
    public double getRadius(Vector2 center) {
        return this.radius + center.distance(this.center);
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 localPoint = transform.getInverseTransformed(point);
        double r = this.getRotation();
        localPoint.rotate(-r, this.ellipseCenter.x, this.ellipseCenter.y);
        double x = localPoint.x - this.ellipseCenter.x;
        double y = localPoint.y - this.ellipseCenter.y;
        if (y < 0.0) {
            return false;
        }
        double x2 = x * x;
        double a2 = this.halfWidth * this.halfWidth;
        double y2 = y * y;
        double b2 = this.height * this.height;
        double value = x2 / a2 + y2 / b2;
        return value <= 1.0;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        this.localXAxis.rotate(theta);
        int i = 0;
        while (i < this.vertices.length) {
            this.vertices[i].rotate(theta, x, y);
            ++i;
        }
        this.ellipseCenter.rotate(theta, x, y);
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        int i = 0;
        while (i < this.vertices.length) {
            this.vertices[i].add(x, y);
            ++i;
        }
        this.ellipseCenter.add(x, y);
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public Vector2 getEllipseCenter() {
        return this.ellipseCenter;
    }
}

