/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Matrix22 {
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix22() {
    }

    public Matrix22(double m00, double m01, double m10, double m11) {
        this.m00 = m00;
        this.m01 = m01;
        this.m10 = m10;
        this.m11 = m11;
    }

    public Matrix22(double[] values) {
        if (values == null) {
            throw new NullPointerException(Messages.getString("geometry.matrix.nullArray"));
        }
        if (values.length != 4) {
            throw new IndexOutOfBoundsException(Messages.getString("geometry.matrix.invalidLength4"));
        }
        this.m00 = values[0];
        this.m01 = values[1];
        this.m10 = values[2];
        this.m11 = values[3];
    }

    public Matrix22(Matrix22 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Matrix22) {
            Matrix22 other = (Matrix22)obj;
            if (other.m00 == this.m00 && other.m01 == this.m01 && other.m10 == this.m10 && other.m11 == this.m11) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.m00).append(" ").append(this.m01).append("][").append(this.m10).append(" ").append(this.m11).append("]");
        return sb.toString();
    }

    public Matrix22 add(Matrix22 matrix) {
        this.m00 += matrix.m00;
        this.m01 += matrix.m01;
        this.m10 += matrix.m10;
        this.m11 += matrix.m11;
        return this;
    }

    public Matrix22 sum(Matrix22 matrix) {
        Matrix22 rm = new Matrix22(this);
        rm.m00 += matrix.m00;
        rm.m01 += matrix.m01;
        rm.m10 += matrix.m10;
        rm.m11 += matrix.m11;
        return rm;
    }

    public Matrix22 subtract(Matrix22 matrix) {
        this.m00 -= matrix.m00;
        this.m01 -= matrix.m01;
        this.m10 -= matrix.m10;
        this.m11 -= matrix.m11;
        return this;
    }

    public Matrix22 difference(Matrix22 matrix) {
        Matrix22 rm = new Matrix22(this);
        rm.m00 -= matrix.m00;
        rm.m01 -= matrix.m01;
        rm.m10 -= matrix.m10;
        rm.m11 -= matrix.m11;
        return rm;
    }

    public Matrix22 multiply(Matrix22 matrix) {
        double m00 = this.m00;
        double m01 = this.m01;
        double m10 = this.m10;
        double m11 = this.m11;
        this.m00 = m00 * matrix.m00 + m01 * matrix.m10;
        this.m01 = m00 * matrix.m01 + m01 * matrix.m11;
        this.m10 = m10 * matrix.m00 + m11 * matrix.m10;
        this.m11 = m10 * matrix.m01 + m11 * matrix.m11;
        return this;
    }

    public Matrix22 product(Matrix22 matrix) {
        Matrix22 rm = new Matrix22();
        rm.m00 = this.m00 * matrix.m00 + this.m01 * matrix.m10;
        rm.m01 = this.m00 * matrix.m01 + this.m01 * matrix.m11;
        rm.m10 = this.m10 * matrix.m00 + this.m11 * matrix.m10;
        rm.m11 = this.m10 * matrix.m01 + this.m11 * matrix.m11;
        return rm;
    }

    public Vector2 multiply(Vector2 vector) {
        double x = vector.x;
        double y = vector.y;
        vector.x = this.m00 * x + this.m01 * y;
        vector.y = this.m10 * x + this.m11 * y;
        return vector;
    }

    public Vector2 product(Vector2 vector) {
        Vector2 r = new Vector2();
        r.x = this.m00 * vector.x + this.m01 * vector.y;
        r.y = this.m10 * vector.x + this.m11 * vector.y;
        return r;
    }

    public Vector2 multiplyT(Vector2 vector) {
        double x = vector.x;
        double y = vector.y;
        vector.x = this.m00 * x + this.m10 * y;
        vector.y = this.m01 * x + this.m11 * y;
        return vector;
    }

    public Vector2 productT(Vector2 vector) {
        Vector2 r = new Vector2();
        r.x = this.m00 * vector.x + this.m10 * vector.y;
        r.y = this.m01 * vector.x + this.m11 * vector.y;
        return r;
    }

    public Matrix22 multiply(double scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        return this;
    }

    public Matrix22 product(double scalar) {
        Matrix22 rm = new Matrix22(this);
        rm.m00 *= scalar;
        rm.m01 *= scalar;
        rm.m10 *= scalar;
        rm.m11 *= scalar;
        return rm;
    }

    public Matrix22 identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        return this;
    }

    public Matrix22 transpose() {
        double m = this.m01;
        this.m01 = this.m10;
        this.m10 = m;
        return this;
    }

    public Matrix22 getTranspose() {
        Matrix22 rm = new Matrix22(this);
        rm.transpose();
        return rm;
    }

    public double determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix22 invert() {
        double det = this.determinant();
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        double a = this.m00;
        double b = this.m01;
        double c = this.m10;
        double d = this.m11;
        this.m00 = det * d;
        this.m01 = -det * b;
        this.m10 = -det * c;
        this.m11 = det * a;
        return this;
    }

    public Matrix22 getInverse() {
        double det = this.determinant();
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        Matrix22 rm = new Matrix22();
        rm.m00 = det * this.m11;
        rm.m01 = -det * this.m01;
        rm.m10 = -det * this.m10;
        rm.m11 = det * this.m00;
        return rm;
    }

    public Vector2 solve(Vector2 b) {
        double det = this.determinant();
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        Vector2 r = new Vector2();
        r.x = det * (this.m11 * b.x - this.m01 * b.y);
        r.y = det * (this.m00 * b.y - this.m10 * b.x);
        return r;
    }
}

