/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class Matrix33 {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix33() {
    }

    public Matrix33(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix33(double[] values) {
        if (values == null) {
            throw new NullPointerException(Messages.getString("geometry.matrix.nullArray"));
        }
        if (values.length != 9) {
            throw new IndexOutOfBoundsException(Messages.getString("geometry.matrix.invalidLength9"));
        }
        this.m00 = values[0];
        this.m01 = values[1];
        this.m02 = values[2];
        this.m10 = values[3];
        this.m11 = values[4];
        this.m12 = values[5];
        this.m20 = values[6];
        this.m21 = values[7];
        this.m22 = values[8];
    }

    public Matrix33(Matrix33 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m02);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m12);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m20);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m21);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m22);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Matrix33) {
            Matrix33 other = (Matrix33)obj;
            if (other.m00 == this.m00 && other.m01 == this.m01 && other.m02 == this.m02 && other.m10 == this.m10 && other.m11 == this.m11 && other.m12 == this.m12 && other.m20 == this.m20 && other.m21 == this.m21 && other.m22 == this.m22) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.m00).append(" ").append(this.m01).append(" ").append(this.m02).append("][").append(this.m10).append(" ").append(this.m11).append(" ").append(this.m12).append("][").append(this.m20).append(" ").append(this.m21).append(" ").append(this.m22).append("]");
        return sb.toString();
    }

    public Matrix33 add(Matrix33 matrix) {
        this.m00 += matrix.m00;
        this.m01 += matrix.m01;
        this.m02 += matrix.m02;
        this.m10 += matrix.m10;
        this.m11 += matrix.m11;
        this.m12 += matrix.m12;
        this.m20 += matrix.m20;
        this.m21 += matrix.m21;
        this.m22 += matrix.m22;
        return this;
    }

    public Matrix33 sum(Matrix33 matrix) {
        Matrix33 rm = new Matrix33(this);
        rm.m00 += matrix.m00;
        rm.m01 += matrix.m01;
        rm.m02 += matrix.m02;
        rm.m10 += matrix.m10;
        rm.m11 += matrix.m11;
        rm.m12 += matrix.m12;
        rm.m20 += matrix.m20;
        rm.m21 += matrix.m21;
        rm.m22 += matrix.m22;
        return rm;
    }

    public Matrix33 subtract(Matrix33 matrix) {
        this.m00 -= matrix.m00;
        this.m01 -= matrix.m01;
        this.m02 -= matrix.m02;
        this.m10 -= matrix.m10;
        this.m11 -= matrix.m11;
        this.m12 -= matrix.m12;
        this.m20 -= matrix.m20;
        this.m21 -= matrix.m21;
        this.m22 -= matrix.m22;
        return this;
    }

    public Matrix33 difference(Matrix33 matrix) {
        Matrix33 rm = new Matrix33(this);
        rm.m00 -= matrix.m00;
        rm.m01 -= matrix.m01;
        rm.m02 -= matrix.m02;
        rm.m10 -= matrix.m10;
        rm.m11 -= matrix.m11;
        rm.m12 -= matrix.m12;
        rm.m20 -= matrix.m20;
        rm.m21 -= matrix.m21;
        rm.m22 -= matrix.m22;
        return rm;
    }

    public Matrix33 multiply(Matrix33 matrix) {
        double m00 = this.m00;
        double m01 = this.m01;
        double m02 = this.m02;
        double m10 = this.m10;
        double m11 = this.m11;
        double m12 = this.m12;
        double m20 = this.m20;
        double m21 = this.m21;
        double m22 = this.m22;
        this.m00 = m00 * matrix.m00 + m01 * matrix.m10 + m02 * matrix.m20;
        this.m01 = m00 * matrix.m01 + m01 * matrix.m11 + m02 * matrix.m21;
        this.m02 = m00 * matrix.m02 + m01 * matrix.m12 + m02 * matrix.m22;
        this.m10 = m10 * matrix.m00 + m11 * matrix.m10 + m12 * matrix.m20;
        this.m11 = m10 * matrix.m01 + m11 * matrix.m11 + m12 * matrix.m21;
        this.m12 = m10 * matrix.m02 + m11 * matrix.m12 + m12 * matrix.m22;
        this.m20 = m20 * matrix.m00 + m21 * matrix.m10 + m22 * matrix.m20;
        this.m21 = m20 * matrix.m01 + m21 * matrix.m11 + m22 * matrix.m21;
        this.m22 = m20 * matrix.m02 + m21 * matrix.m12 + m22 * matrix.m22;
        return this;
    }

    public Matrix33 product(Matrix33 matrix) {
        Matrix33 rm = new Matrix33();
        rm.m00 = this.m00 * matrix.m00 + this.m01 * matrix.m10 + this.m02 * matrix.m20;
        rm.m01 = this.m00 * matrix.m01 + this.m01 * matrix.m11 + this.m02 * matrix.m21;
        rm.m02 = this.m00 * matrix.m02 + this.m01 * matrix.m12 + this.m02 * matrix.m22;
        rm.m10 = this.m10 * matrix.m00 + this.m11 * matrix.m10 + this.m12 * matrix.m20;
        rm.m11 = this.m10 * matrix.m01 + this.m11 * matrix.m11 + this.m12 * matrix.m21;
        rm.m12 = this.m10 * matrix.m02 + this.m11 * matrix.m12 + this.m12 * matrix.m22;
        rm.m20 = this.m20 * matrix.m00 + this.m21 * matrix.m10 + this.m22 * matrix.m20;
        rm.m21 = this.m20 * matrix.m01 + this.m21 * matrix.m11 + this.m22 * matrix.m21;
        rm.m22 = this.m20 * matrix.m02 + this.m21 * matrix.m12 + this.m22 * matrix.m22;
        return rm;
    }

    public Vector3 multiply(Vector3 vector) {
        double x = vector.x;
        double y = vector.y;
        double z = vector.z;
        vector.x = this.m00 * x + this.m01 * y + this.m02 * z;
        vector.y = this.m10 * x + this.m11 * y + this.m12 * z;
        vector.z = this.m20 * x + this.m21 * y + this.m22 * z;
        return vector;
    }

    public Vector3 product(Vector3 vector) {
        Vector3 r = new Vector3();
        r.x = this.m00 * vector.x + this.m01 * vector.y + this.m02 * vector.z;
        r.y = this.m10 * vector.x + this.m11 * vector.y + this.m12 * vector.z;
        r.z = this.m20 * vector.x + this.m21 * vector.y + this.m22 * vector.z;
        return r;
    }

    public Vector3 multiplyT(Vector3 vector) {
        double x = vector.x;
        double y = vector.y;
        double z = vector.z;
        vector.x = this.m00 * x + this.m10 * y + this.m20 * z;
        vector.y = this.m01 * x + this.m11 * y + this.m21 * z;
        vector.z = this.m02 * x + this.m12 * y + this.m22 * z;
        return vector;
    }

    public Vector3 productT(Vector3 vector) {
        Vector3 r = new Vector3();
        r.x = this.m00 * vector.x + this.m10 * vector.y + this.m20 * vector.z;
        r.y = this.m01 * vector.x + this.m11 * vector.y + this.m21 * vector.z;
        r.z = this.m02 * vector.x + this.m12 * vector.y + this.m22 * vector.z;
        return r;
    }

    public Matrix33 multiply(double scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
        return this;
    }

    public Matrix33 product(double scalar) {
        Matrix33 rm = new Matrix33(this);
        rm.m00 *= scalar;
        rm.m01 *= scalar;
        rm.m02 *= scalar;
        rm.m10 *= scalar;
        rm.m11 *= scalar;
        rm.m12 *= scalar;
        rm.m20 *= scalar;
        rm.m21 *= scalar;
        rm.m22 *= scalar;
        return rm;
    }

    public Matrix33 identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix33 transpose() {
        double s = this.m01;
        this.m01 = this.m10;
        this.m10 = s;
        s = this.m02;
        this.m02 = this.m20;
        this.m20 = s;
        s = this.m12;
        this.m12 = this.m21;
        this.m21 = s;
        return this;
    }

    public Matrix33 getTranspose() {
        Matrix33 rm = new Matrix33();
        rm.m00 = this.m00;
        rm.m01 = this.m10;
        rm.m02 = this.m20;
        rm.m10 = this.m01;
        rm.m11 = this.m11;
        rm.m12 = this.m21;
        rm.m20 = this.m02;
        rm.m21 = this.m12;
        rm.m22 = this.m22;
        return rm;
    }

    public double determinant() {
        return this.m00 * this.m11 * this.m22 + this.m01 * this.m12 * this.m20 + this.m02 * this.m10 * this.m21 - this.m20 * this.m11 * this.m02 - this.m21 * this.m12 * this.m00 - this.m22 * this.m10 * this.m01;
    }

    public Matrix33 invert() {
        double det = this.determinant();
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        double m00 = det * (this.m11 * this.m22 - this.m12 * this.m21);
        double m01 = -det * (this.m01 * this.m22 - this.m21 * this.m02);
        double m02 = det * (this.m01 * this.m12 - this.m11 * this.m02);
        double m10 = -det * (this.m10 * this.m22 - this.m20 * this.m12);
        double m11 = det * (this.m00 * this.m22 - this.m20 * this.m02);
        double m12 = -det * (this.m00 * this.m12 - this.m10 * this.m02);
        double m20 = det * (this.m10 * this.m21 - this.m20 * this.m11);
        double m21 = -det * (this.m00 * this.m21 - this.m20 * this.m01);
        double m22 = det * (this.m00 * this.m11 - this.m10 * this.m01);
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public Matrix33 getInverse() {
        Matrix33 rm = new Matrix33();
        double det = this.determinant();
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        rm.m00 = det * (this.m11 * this.m22 - this.m12 * this.m21);
        rm.m01 = -det * (this.m01 * this.m22 - this.m21 * this.m02);
        rm.m02 = det * (this.m01 * this.m12 - this.m11 * this.m02);
        rm.m10 = -det * (this.m10 * this.m22 - this.m20 * this.m12);
        rm.m11 = det * (this.m00 * this.m22 - this.m20 * this.m02);
        rm.m12 = -det * (this.m00 * this.m12 - this.m10 * this.m02);
        rm.m20 = det * (this.m10 * this.m21 - this.m20 * this.m11);
        rm.m21 = -det * (this.m00 * this.m21 - this.m20 * this.m01);
        rm.m22 = det * (this.m00 * this.m11 - this.m10 * this.m01);
        return rm;
    }

    public Vector3 solve33(Vector3 b) {
        double det = this.determinant();
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        Vector3 r = new Vector3();
        double m00 = this.m11 * this.m22 - this.m12 * this.m21;
        double m01 = -this.m01 * this.m22 + this.m21 * this.m02;
        double m02 = this.m01 * this.m12 - this.m11 * this.m02;
        double m10 = -this.m10 * this.m22 + this.m20 * this.m12;
        double m11 = this.m00 * this.m22 - this.m20 * this.m02;
        double m12 = -this.m00 * this.m12 + this.m10 * this.m02;
        double m20 = this.m10 * this.m21 - this.m20 * this.m11;
        double m21 = -this.m00 * this.m21 + this.m20 * this.m01;
        double m22 = this.m00 * this.m11 - this.m10 * this.m01;
        r.x = det * (m00 * b.x + m01 * b.y + m02 * b.z);
        r.y = det * (m10 * b.x + m11 * b.y + m12 * b.z);
        r.z = det * (m20 * b.x + m21 * b.y + m22 * b.z);
        return r;
    }

    public Vector2 solve22(Vector2 b) {
        double det = this.m00 * this.m11 - this.m01 * this.m10;
        if (Math.abs(det) > Epsilon.E) {
            det = 1.0 / det;
        }
        Vector2 r = new Vector2();
        r.x = det * (this.m11 * b.x - this.m01 * b.y);
        r.y = det * (this.m00 * b.y - this.m10 * b.x);
        return r;
    }
}

