/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.Iterator;
import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.EdgeFeature;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Wound;
import org.dyn4j.geometry.WoundIterator;
import org.dyn4j.resources.Messages;

public class Polygon
extends AbstractShape
implements Convex,
Wound,
Shape,
Transformable,
DataContainer {
    final Vector2[] vertices;
    final Vector2[] normals;

    Polygon(Vector2 center, double radius, Vector2[] vertices, Vector2[] normals) {
        super(center, radius);
        this.vertices = vertices;
        this.normals = normals;
    }

    private Polygon(boolean valid, Vector2[] vertices, Vector2 center) {
        super(center, Geometry.getRotationRadius(center, vertices));
        this.vertices = vertices;
        this.normals = Geometry.getCounterClockwiseEdgeNormals(vertices);
    }

    public Polygon(Vector2 ... vertices) {
        this(Polygon.validate(vertices), vertices, Geometry.getAreaWeightedCenter(vertices));
    }

    private static final boolean validate(Vector2 ... vertices) {
        if (vertices == null) {
            throw new NullPointerException(Messages.getString("geometry.polygon.nullArray"));
        }
        int size = vertices.length;
        if (size < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.polygon.lessThan3Vertices"));
        }
        int i = 0;
        while (i < size) {
            if (vertices[i] == null) {
                throw new NullPointerException(Messages.getString("geometry.polygon.nullVertices"));
            }
            ++i;
        }
        double area = 0.0;
        double sign = 0.0;
        int i2 = 0;
        while (i2 < size) {
            Vector2 p2;
            Vector2 p0 = i2 - 1 < 0 ? vertices[size - 1] : vertices[i2 - 1];
            Vector2 p1 = vertices[i2];
            Vector2 vector2 = p2 = i2 + 1 == size ? vertices[0] : vertices[i2 + 1];
            if (p1.equals(p2)) {
                throw new IllegalArgumentException(Messages.getString("geometry.polygon.coincidentVertices"));
            }
            double cross = p0.to(p1).cross(p1.to(p2));
            double tsign = Math.signum(cross);
            area += cross;
            if (Math.abs(cross) > Epsilon.E && sign != 0.0 && tsign != sign) {
                throw new IllegalArgumentException(Messages.getString("geometry.polygon.nonConvex"));
            }
            sign = tsign;
            ++i2;
        }
        if (area < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.polygon.invalidWinding"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon[").append(super.toString()).append("|Vertices={");
        int i = 0;
        while (i < this.vertices.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.vertices[i]);
            ++i;
        }
        sb.append("}").append("]");
        return sb.toString();
    }

    @Override
    public Vector2[] getVertices() {
        return this.vertices;
    }

    @Override
    public Vector2[] getNormals() {
        return this.normals;
    }

    @Override
    public Iterator<Vector2> getVertexIterator() {
        return new WoundIterator(this.vertices);
    }

    @Override
    public Iterator<Vector2> getNormalIterator() {
        return new WoundIterator(this.normals);
    }

    @Override
    public double getRadius(Vector2 center) {
        return Geometry.getRotationRadius(center, this.vertices);
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        int fociSize = foci != null ? foci.length : 0;
        int size = this.vertices.length;
        Vector2[] axes = new Vector2[size + fociSize];
        int n = 0;
        int i = 0;
        while (i < size) {
            Vector2 v = this.normals[i];
            axes[n++] = transform.getTransformedR(v);
            ++i;
        }
        i = 0;
        while (i < fociSize) {
            Vector2 f = foci[i];
            Vector2 closest = transform.getTransformed(this.vertices[0]);
            double d = f.distanceSquared(closest);
            int j = 1;
            while (j < size) {
                Vector2 p = this.vertices[j];
                double dt = f.distanceSquared(p = transform.getTransformed(p));
                if (dt < d) {
                    closest = p;
                    d = dt;
                }
                ++j;
            }
            Vector2 axis = f.to(closest);
            axis.normalize();
            axes[n++] = axis;
            ++i;
        }
        return axes;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return null;
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 p = transform.getInverseTransformed(point);
        Vector2 p1 = this.vertices[0];
        Vector2 p2 = this.vertices[1];
        double last = Segment.getLocation(p, p1, p2);
        int size = this.vertices.length;
        int i = 1;
        while (i < size) {
            p1 = p2;
            p2 = this.vertices[i + 1 == size ? 0 : i + 1];
            if (p.equals(p1)) {
                return true;
            }
            if (last * Segment.getLocation(p, p1, p2) < 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        int size = this.vertices.length;
        int i = 0;
        while (i < size) {
            this.vertices[i].rotate(theta, x, y);
            this.normals[i].rotate(theta);
            ++i;
        }
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        int size = this.vertices.length;
        int i = 0;
        while (i < size) {
            this.vertices[i].add(x, y);
            ++i;
        }
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        double min;
        double v = 0.0;
        Vector2 p = transform.getTransformed(this.vertices[0]);
        double max = min = vector.dot(p);
        int size = this.vertices.length;
        int i = 1;
        while (i < size) {
            p = transform.getTransformed(this.vertices[i]);
            v = vector.dot(p);
            if (v < min) {
                min = v;
            } else if (v > max) {
                max = v;
            }
            ++i;
        }
        return new Interval(min, max);
    }

    @Override
    public EdgeFeature getFarthestFeature(Vector2 vector, Transform transform) {
        Vector2 localn = transform.getInverseTransformedR(vector);
        Vector2 maximum = new Vector2();
        double max = -1.7976931348623157E308;
        int index = 0;
        int count = this.vertices.length;
        int i = 0;
        while (i < count) {
            Vector2 v = this.vertices[i];
            double projection = localn.dot(v);
            if (projection > max) {
                maximum.set(v);
                max = projection;
                index = i;
            }
            ++i;
        }
        int l = index + 1 == count ? 0 : index + 1;
        int r = index - 1 < 0 ? count - 1 : index - 1;
        Vector2 leftN = this.normals[index == 0 ? count - 1 : index - 1];
        Vector2 rightN = this.normals[index];
        transform.transform(maximum);
        PointFeature vm = new PointFeature(maximum, index);
        if (leftN.dot(localn) < rightN.dot(localn)) {
            Vector2 left = transform.getTransformed(this.vertices[l]);
            PointFeature vl = new PointFeature(left, l);
            return new EdgeFeature(vm, vl, vm, maximum.to(left), index + 1);
        }
        Vector2 right = transform.getTransformed(this.vertices[r]);
        PointFeature vr = new PointFeature(right, r);
        return new EdgeFeature(vr, vm, vm, right.to(maximum), index);
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        Vector2 localn = transform.getInverseTransformedR(vector);
        Vector2 point = new Vector2();
        point.set(this.vertices[0]);
        double max = localn.dot(this.vertices[0]);
        int size = this.vertices.length;
        int i = 1;
        while (i < size) {
            Vector2 v = this.vertices[i];
            double projection = localn.dot(v);
            if (projection > max) {
                point.set(v);
                max = projection;
            }
            ++i;
        }
        transform.transform(point);
        return point;
    }

    @Override
    public Mass createMass(double density) {
        Vector2 center = new Vector2();
        double area = 0.0;
        double I = 0.0;
        int n = this.vertices.length;
        Vector2 ac = new Vector2();
        int i = 0;
        while (i < n) {
            ac.add(this.vertices[i]);
            ++i;
        }
        ac.multiply(1.0 / (double)n);
        i = 0;
        while (i < n) {
            Vector2 p1 = this.vertices[i];
            Vector2 p2 = i + 1 < n ? this.vertices[i + 1] : this.vertices[0];
            p1 = p1.difference(ac);
            p2 = p2.difference(ac);
            double D = p1.cross(p2);
            double triangleArea = 0.5 * D;
            area += triangleArea;
            center.x += (p1.x + p2.x) * 0.3333333333333333 * triangleArea;
            center.y += (p1.y + p2.y) * 0.3333333333333333 * triangleArea;
            I += triangleArea * (p2.dot(p2) + p2.dot(p1) + p1.dot(p1));
            ++i;
        }
        double m = density * area;
        center.multiply(1.0 / area);
        Vector2 c = center.sum(ac);
        I *= density / 6.0;
        return new Mass(c, m, I -= m * center.getMagnitudeSquared());
    }

    @Override
    public AABB createAABB(Transform transform) {
        double minY;
        double minX;
        double vx = 0.0;
        double vy = 0.0;
        Vector2 p = transform.getTransformed(this.vertices[0]);
        double maxX = minX = Vector2.X_AXIS.dot(p);
        double maxY = minY = Vector2.Y_AXIS.dot(p);
        int size = this.vertices.length;
        int i = 1;
        while (i < size) {
            p = transform.getTransformed(this.vertices[i]);
            vx = Vector2.X_AXIS.dot(p);
            vy = Vector2.Y_AXIS.dot(p);
            if (vx < minX) {
                minX = vx;
            } else if (vx > maxX) {
                maxX = vx;
            }
            if (vy < minY) {
                minY = vy;
            } else if (vy > maxY) {
                maxY = vy;
            }
            ++i;
        }
        return new AABB(minX, minY, maxX, maxY);
    }
}

