/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Wound;

public class Triangle
extends Polygon
implements Convex,
Wound,
Shape,
Transformable,
DataContainer {
    public Triangle(Vector2 point1, Vector2 point2, Vector2 point3) {
        super(point1, point2, point3);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Triangle[").append(super.toString()).append("]");
        return sb.toString();
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        double denominator;
        double invD;
        double dot12;
        Vector2 p = transform.getInverseTransformed(point);
        Vector2 p1 = this.vertices[0];
        Vector2 p2 = this.vertices[1];
        Vector2 p3 = this.vertices[2];
        Vector2 ab = p1.to(p2);
        Vector2 ac = p1.to(p3);
        Vector2 pa = p1.to(p);
        double dot00 = ac.dot(ac);
        double dot01 = ac.dot(ab);
        double dot02 = ac.dot(pa);
        double dot11 = ab.dot(ab);
        double u = (dot11 * dot02 - dot01 * (dot12 = ab.dot(pa))) * (invD = 1.0 / (denominator = dot00 * dot11 - dot01 * dot01));
        if (u <= 0.0) {
            return false;
        }
        double v = (dot00 * dot12 - dot01 * dot02) * invD;
        return v > 0.0 && u + v <= 1.0;
    }
}

