/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import org.dyn4j.Reference;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.SweepLineVertex;

final class SweepLineEdge
implements Comparable<SweepLineEdge> {
    final Reference<Double> referenceY;
    SweepLineVertex v0;
    SweepLineVertex v1;
    SweepLineVertex helper;
    double slope;

    public SweepLineEdge(Reference<Double> referenceY) {
        this.referenceY = referenceY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.v0).append(" to ").append(this.v1);
        return sb.toString();
    }

    @Override
    public int compareTo(SweepLineEdge o) {
        double x2;
        if (this == o) {
            return 0;
        }
        double y = (Double)this.referenceY.value;
        double x1 = this.getSortValue(y);
        if (x1 < (x2 = o.getSortValue(y))) {
            return -1;
        }
        return 1;
    }

    public double getSortValue(double y) {
        Vector2 min = this.v0.point;
        if (this.v1.point.x < this.v0.point.x) {
            min = this.v1.point;
        }
        if (this.slope == Double.POSITIVE_INFINITY) {
            return min.x;
        }
        return min.x + (y - min.y) * this.slope;
    }

    public boolean isInteriorRight() {
        double diff = this.v0.point.y - this.v1.point.y;
        if (diff == 0.0) {
            return this.v0.point.x < this.v1.point.x;
        }
        return diff > 0.0;
    }
}

