/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.PriorityQueue;
import org.dyn4j.BinarySearchTree;
import org.dyn4j.Reference;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.DoubleEdgeList;
import org.dyn4j.geometry.decompose.SweepLineEdge;
import org.dyn4j.geometry.decompose.SweepLineVertex;
import org.dyn4j.geometry.decompose.SweepLineVertexType;
import org.dyn4j.resources.Messages;

final class SweepLineState {
    final Reference<Double> referenceY = new Reference<Double>(0.0);
    final BinarySearchTree<SweepLineEdge> tree = new BinarySearchTree(true);
    DoubleEdgeList dcel;

    final PriorityQueue<SweepLineVertex> initialize(Vector2[] points) {
        this.dcel = new DoubleEdgeList(points);
        int size = points.length;
        PriorityQueue<SweepLineVertex> queue = new PriorityQueue<SweepLineVertex>(size);
        SweepLineVertex rootVertex = null;
        SweepLineVertex prevVertex = null;
        SweepLineEdge rootEdge = null;
        SweepLineEdge prevEdge = null;
        int i = 0;
        while (i < size) {
            Vector2 point = points[i];
            SweepLineVertex vertex = new SweepLineVertex(point, i);
            vertex.type = SweepLineVertexType.REGULAR;
            vertex.prev = prevVertex;
            if (prevVertex != null) {
                prevVertex.next = vertex;
            }
            if (rootVertex == null) {
                rootVertex = vertex;
            }
            Vector2 point1 = points[i + 1 == size ? 0 : i + 1];
            Vector2 point0 = points[i == 0 ? size - 1 : i - 1];
            vertex.type = this.getType(point0, point, point1);
            prevVertex = vertex;
            queue.offer(vertex);
            SweepLineEdge e = new SweepLineEdge(this.referenceY);
            e.v0 = vertex;
            double my = point.y - point1.y;
            if (my == 0.0) {
                e.slope = Double.POSITIVE_INFINITY;
            } else {
                double mx = point.x - point1.x;
                e.slope = mx / my;
            }
            if (prevEdge != null) {
                prevEdge.v1 = vertex;
            }
            if (rootEdge == null) {
                rootEdge = e;
            }
            vertex.left = e;
            vertex.right = prevEdge;
            prevEdge = e;
            ++i;
        }
        prevEdge.v1 = rootEdge.v0;
        rootVertex.right = prevEdge;
        rootVertex.prev = prevVertex;
        prevVertex.next = rootVertex;
        return queue;
    }

    final SweepLineVertexType getType(Vector2 point0, Vector2 point, Vector2 point1) {
        Vector2 v1 = point0.to(point);
        Vector2 v2 = point.to(point1);
        if (v1.isZero() || v2.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.coincident"));
        }
        double cross = v1.cross(v2);
        boolean pBelowP0 = this.isBelow(point, point0);
        boolean pBelowP1 = this.isBelow(point, point1);
        if (pBelowP0 && pBelowP1) {
            if (cross > 0.0) {
                return SweepLineVertexType.END;
            }
            return SweepLineVertexType.MERGE;
        }
        if (!pBelowP0 && !pBelowP1) {
            if (cross > 0.0) {
                return SweepLineVertexType.START;
            }
            return SweepLineVertexType.SPLIT;
        }
        return SweepLineVertexType.REGULAR;
    }

    public boolean isBelow(Vector2 p, Vector2 q) {
        double diff = p.y - q.y;
        if (diff == 0.0) {
            return p.x > q.x;
        }
        return diff < 0.0;
    }
}

