/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.SweepLineEdge;
import org.dyn4j.geometry.decompose.SweepLineVertexType;

final class SweepLineVertex
implements Comparable<SweepLineVertex> {
    final Vector2 point;
    final int index;
    SweepLineVertexType type;
    SweepLineVertex next;
    SweepLineVertex prev;
    SweepLineEdge left;
    SweepLineEdge right;

    public SweepLineVertex(Vector2 point, int index) {
        this.point = point;
        this.index = index;
    }

    @Override
    public int compareTo(SweepLineVertex other) {
        Vector2 p = this.point;
        Vector2 q = other.point;
        double diff = q.y - p.y;
        if (diff == 0.0) {
            return (int)Math.signum(p.x - q.x);
        }
        return (int)Math.signum(diff);
    }

    public String toString() {
        return this.point.toString();
    }

    final boolean isLeft(SweepLineEdge edge) {
        double location = Segment.getLocation(this.point, edge.v0.point, edge.v1.point);
        return location < 0.0;
    }

    public boolean isInteriorRight() {
        return this.left.isInteriorRight();
    }
}

