/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.ArrayList;
import java.util.Arrays;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.geometry.hull.ReferencePointComparator;
import org.dyn4j.resources.Messages;

public class GrahamScan
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int size = points.length;
        if (size <= 2) {
            return points;
        }
        Vector2 minY = points[0];
        int i = 1;
        while (i < size) {
            Vector2 p = points[i];
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
            }
            if (p.y < minY.y) {
                minY = p;
            } else if (p.y == minY.y && p.x < minY.x) {
                minY = p;
            }
            ++i;
        }
        ReferencePointComparator pc = new ReferencePointComparator(minY);
        Arrays.sort(points, pc);
        ArrayList<Vector2> stack = new ArrayList<Vector2>();
        stack.add(points[0]);
        stack.add(points[1]);
        int i2 = 2;
        while (i2 < size) {
            Vector2 p2;
            int sSize = stack.size();
            if (sSize == 1) {
                stack.add(points[i2]);
                ++i2;
                continue;
            }
            Vector2 p3 = points[i2];
            Vector2 p1 = (Vector2)stack.get(sSize - 2);
            double location = Segment.getLocation(p3, p1, p2 = (Vector2)stack.get(sSize - 1));
            if (location > 0.0) {
                stack.add(p3);
                ++i2;
                continue;
            }
            stack.remove(sSize - 1);
        }
        Vector2[] hull = new Vector2[stack.size()];
        stack.toArray(hull);
        return hull;
    }
}

