/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.ArrayList;
import java.util.Arrays;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.geometry.hull.MinXYPointComparator;
import org.dyn4j.resources.Messages;

public class MonotoneChain
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int size = points.length;
        if (size <= 2) {
            return points;
        }
        try {
            Arrays.sort(points, new MinXYPointComparator());
        }
        catch (NullPointerException e) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
        }
        int minmin = 0;
        int minmax = 0;
        int maxmin = 0;
        int maxmax = 0;
        int i = 1;
        while (i < size) {
            Vector2 minxminy = points[minmin];
            Vector2 minxmaxy = points[minmax];
            Vector2 maxxminy = points[maxmin];
            Vector2 maxxmaxy = points[maxmax];
            Vector2 p = points[i];
            if (p.x < minxminy.x) {
                minmin = i;
                minmax = i;
            } else if (p.x == minxminy.x) {
                if (p.y > minxmaxy.y) {
                    minmax = i;
                } else if (p.y < minxminy.y) {
                    minmin = i;
                }
            }
            if (p.x > maxxminy.x) {
                maxmin = i;
                maxmax = i;
            } else if (p.x == maxxminy.x) {
                if (p.y > maxxmaxy.y) {
                    maxmax = i;
                } else if (p.y < maxxminy.y) {
                    maxmin = i;
                }
            }
            ++i;
        }
        ArrayList<Vector2> lower = new ArrayList<Vector2>();
        Vector2 lp1 = points[maxmin];
        Vector2 lp2 = points[minmin];
        lower.add(points[minmin]);
        int i2 = minmax + 1;
        while (i2 <= maxmin) {
            Vector2 p = points[i2];
            if (Segment.getLocation(p, lp1, lp2) >= 0.0) {
                int lSize = lower.size();
                while (lSize >= 2) {
                    Vector2 p1 = (Vector2)lower.get(lSize - 1);
                    Vector2 p2 = (Vector2)lower.get(lSize - 2);
                    if (Segment.getLocation(p, p2, p1) > 0.0) break;
                    lower.remove(lSize - 1);
                    --lSize;
                }
                lower.add(p);
            }
            ++i2;
        }
        ArrayList<Vector2> upper = new ArrayList<Vector2>();
        Vector2 up1 = points[minmax];
        Vector2 up2 = points[maxmax];
        upper.add(points[maxmax]);
        int i3 = maxmax - 1;
        while (i3 >= minmax) {
            Vector2 p = points[i3];
            if (Segment.getLocation(p, up1, up2) >= 0.0) {
                int uSize = upper.size();
                while (uSize >= 2) {
                    Vector2 p1 = (Vector2)upper.get(uSize - 1);
                    Vector2 p2 = (Vector2)upper.get(uSize - 2);
                    if (Segment.getLocation(p, p2, p1) > 0.0) break;
                    upper.remove(uSize - 1);
                    --uSize;
                }
                upper.add(p);
            }
            --i3;
        }
        if (upper.get(0) == lower.get(lower.size() - 1)) {
            upper.remove(0);
        }
        if (lower.get(0) == upper.get(upper.size() - 1)) {
            lower.remove(0);
        }
        lower.addAll(upper);
        Vector2[] hull = new Vector2[lower.size()];
        lower.toArray(hull);
        return hull;
    }
}

