# <font color=Black>Spartan-NFT-1155</font>

<br/>

## <font color=Black>Function Introduction</font>
---

Spartan-NFT-1155 proxy contract is used to provide users with a set of APIs, including mint and batch mint Spartan-NFTs under the standard of ERC1155, as well as authorization, query authorization, transfer, batch transfer and destruction. The purpose of this set of smart contracts is to allow end-users to directly mint ERC1155 NFTs under the governance of BSN Foundation.


**Smart contract address:**

Spartan-I Chain (Powered by NC Ethereum): `0xD4366bBeF0977f278A91Ae20EfE8A035690Ac90B`

Spartan-II Chain (Powered by NC Cosmos): `0xD0Bf538c75310917b2C82C0a715E126783Be030F`

Spartan-III Chain (Powered by NC PolygonEdge): `0x0c0f445f359eBa39935012C0EEeaFE3cA00B6BFb`

**Example:** https://github.com/BSN-Spartan/NFT.git


<br/>

## <font color=Black>API Definition</font>
---


### <font color=Black>Safe Mint</font>


Users can call this interface to safe mint the NFT.

Input parameters: receiver address, NFT name, NFT symbol, number of copies of the NFT, uri, attached args;

- **Output parameters:** none;

- **Function definition:** safeMint (address to, string memory name, string memory symbol, uint256 amount, string memory tokenURI, bytes memory data);

- **Event parameters:** operator, 0x0 address (null address), receiver address, NFT token ID, number of copies;

- **Event definition:** TransferSingle (operator, address (0), to, tokenID, amount);

- **Example:**

```groovy
   func TestSafeMint(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   amount := new(big.Int).SetUint64(1)
   data := []byte{0x1}
   tx, err := session.SafeMint(common.HexToAddress(owner), "sparton_nft", "sparton_nft", amount, "sparton_nft", data)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Batch Safe Mint NFT</font>


Users can call this interface to safer mint the NFT in batch.

- **Input parameters:** receiver address, NFT name set, NFT symbol set, number of NFT copies set, uri set, attached args;

- **Output parameters:** none;

- **Function name:** safeMintBatch;

- **Function definition:** safeMintBatch (address to, string[] memory names, string[] memory symbols, uint256[] memory amounts, string[] memory tokenURIs, bytes memory data);

- **Event parameters:** operator, 0x0 address (null address), receiver address, NFT token ID set, number of copies set;

- **Event definition:** TransferBatch (operator, address (0), to, tokenIDs, amounts);

- **Example:**

```groovy 
   func TestSafeMintBatch(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenName := []string{"sparton_nft_1", "sparton_nft_2"}
   tokenSymbol := []string{"sparton_nft_1", "sparton_nft_2"}
   tokenURIs := []string{"http://sparton.json", "http://sparton.json"}
   var amount []*big.Int
   amount = append(amount, new(big.Int).SetUint64(1), new(big.Int).SetUint64(1))
   data := []byte{0x1, 0x2}
   tx, err := session.SafeMintBatch(common.HexToAddress(owner), tokenName, tokenSymbol, amount, tokenURIs, data)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```


<br/>

### <font color=Black>Wallet Authorization</font>


NFT owner can call this interface to wallet authorization, the sender of the transaction must be the NFT owner.

- **Input parameters:** authorizer’s wallet address, authorization ID;

- **Output parameters:** none;

- **Function definition:** setApprovalForAll (address operator, bool approved);

- **Event parameters:** NFT owner, authorizer’s wallet address, authorization ID;

- **Event definition:** ApprovalForAll (owner, operator, approved);

- **Example:**

```groovy 
   func TestSetApprovalForAll(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.SetApprovalForAll(common.HexToAddress(account), true)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Verify Wallet Authorization</font>


Users can call this interface to verify the wallet authorization.

- **Input parameters:** owner’s wallet address, authorizer’s wallet address;

- **Output parameters:** Boolean value;

- **Function definition:** isApprovedForAll (address owner, address operator) view returns (bool);

- **Example:** 

```groovy
   func TestIsApprovedForAll(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.IsApprovedForAll(common.HexToAddress(owner), common.HexToAddress(account))
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("Is ApprovedForAll:%t", tx))
}
```

<br/>

### <font color=Black>Safe Transfer</font>


An NFT owner or authorized wallet address can call this interface to transfer the NFT. 

- **Input parameters:** owner’s wallet address, receiver’s wallet address, NFT token ID, number of copies, attached args;

- **Output parameters:** none;

- **Function definition:** safeTransferFrom (address from, address to, uint256 tokenID, uint256 amount, bytes memory data);

- **Event parameters:** operator, owner’s wallet address, receiver’s wallet address, NFT token ID, number of copies;

- **Event definition:** TransferSingle (operator, from, to, tokenID, amount);

- **Example:** 

```groovy
   func TestSafeTransferFrom(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   data := []byte{0x1}
   tokenId := new(big.Int).SetUint64(1)
   amount := new(big.Int).SetUint64(1)
   tx, err := session.SafeTransferFrom(common.HexToAddress(owner), common.HexToAddress(account), tokenId, amount, data)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Batch Safe Transfer</font>


An NFT owner or authorized wallet address can call this interface to transfer NFTs in batch.

- **Input parameters:** owner’s wallet address, receiver’s wallet address, NFT token ID set, number of copies set, attached args;

- **Output parameters:** none;

- **Function definition:** safeBatchTransferFrom (address from, address to, uint256[] memory tokenIDs, uint256[] memory amounts, bytes memory data);

- **Event parameters:** operator, owner’s wallet address, receiver’s wallet address, NFT token ID set, number of copies set;

- **Event definition:** TransferBatch (operator, from, to, tokenIDs, amounts);

- **Example:**

```groovy
   func TestSafeBatchTransferFrom(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }

   var tokenIDs []*big.Int
   tokenIDs = append(tokenIDs, new(big.Int).SetUint64(1), new(big.Int).SetUint64(2))

   var amount []*big.Int
   amount = append(amount, new(big.Int).SetUint64(1), new(big.Int).SetUint64(1))

   data := []byte{0x1, 0x2}
   tx, err := session.SafeBatchTransferFrom(common.HexToAddress(owner), common.HexToAddress(account), tokenIDs, amount, data)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>NFT Destruction</font>


An NFT owner or authorized wallet address can call this interface to destroy the NFT.

- **Input parameters:** owner’s wallet address, NFT token ID;

- **Output parameters:** none;

- **Function definition:** burn (address owner, uint256 tokenID);

- **Event parameters:** operator, owner’s wallet address, 0x0 address (null address), NFT token ID, number of copies;

- **Event definition:** TransferSingle (operator, owner, address (0), tokenID, amount);

- **Example:** 

```groovy
   func TestBurn(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(1)
   tx, err := session.Burn(common.HexToAddress(owner), tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Batch Destruction</font>


An NFT owner or authorized wallet address can call this interface to destroy NFTs in batch.

- **Input parameters:** owner’s wallet address, NFT token ID set;

- **Output parameters:** none;

- **Function definition:** burnBatch (address owner, uint256[] memory tokenIDs);

- **Event parameters:** operator, owner’s wallet address, 0x0 address (null address), NFT token ID set, number of copies set;

- **Event definition:** TransferBatch (operator, owner, address (0), tokenIDs, amounts);

- **Example:** 

```groovy
   func TestBurnBatch(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   var tokenIDs []*big.Int
   tokenIDs = append(tokenIDs, new(big.Int).SetUint64(3), new(big.Int).SetUint64(4))

   tx, err := session.BurnBatch(common.HexToAddress(owner), tokenIDs)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Query Number of NFT Copies</font>

Users can call this interface to query the number of NFT copies held by this wallet address.

- **Input parameters:** owner’s wallet address, NFT token ID;

- **Output parameters:** number of copies;

- **Function definition:** balanceOf (address owner, uint256 tokenID) view returns (uint256);

- **Example:** 

```groovy
   func TestBalanceOf(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(3)
   tx, err := session.BalanceOf(common.HexToAddress(owner), tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("Account balance: %s", tx))
}
```

<br/>

### <font color=Black>Batch Query the Number of NFT Copies</font>

 
Users can call this interface to query the number of NFT copies held by this wallet address in batches.

- **Input parameters:** owner’s wallet address set, NFT token ID set;

- **Output parameters:** number of copies set;

- **Function definition:** balanceOfBatch (address[] memory owners, uint256[] memory tokenIDs) view returns (uint256[] memory);

- **Example:**

```groovy
   func TestBalanceOfBatch(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   var tokenIDs []*big.Int
   tokenIDs = append(tokenIDs, new(big.Int).SetUint64(3), new(big.Int).SetUint64(4))

   var owners []common.Address
   owners = append(owners, common.HexToAddress(owner), common.HexToAddress(account))

   tx, err := session.BalanceOfBatch(owners, tokenIDs)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("owners balance: %s", tx))
}
```

<br/>

### <font color=Black>Query NFT Name</font>


Users can call this interface to query the name of the NFT.

- **Input parameters:** NFT token ID;

- **Output parameters:** NFT name;

- **Function definition:** tokenName (uint256 tokenID) view returns (string memory);

- **Example:**


```groovy
   func TestTokenName(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(3)
   tx, err := session.TokenName(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("NFT name: %s", tx))
}
```

<br/>

### <font color=Black>Query NFT Symbol</font>


Users can call this interface to query the NFT symbol.

- **Input parameters:** NFT token ID;

- **Output parameters:** NFT symbol;

- **Function definition:** tokenSymbol (uint256 tokenID) view returns (string memory);

- **Example:**

```groovy
   func TestTokenSymbol(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.TokenSymbol(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("NFT symbol: %s", tx))
}
```

<br/>

### <font color=Black>Query NFT URI</font>


Users can call this interface to query the NFT URI.

- **Input parameters:** NFT token ID;

- **Output parameters:** NFT URI;

- **Function definition:** tokenURI (uint256 tokenID) view returns (string memory);

- **Example:** 

```groovy
   func TestTokenURI(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.TokenURI(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("NFT URI: %s", tx))
}
```


<br/>

### <font color=Black>Query the Latest NFT Token ID</font>


Users can call this interface to query the latest NFT token ID.

- **Input parameters:** none;

- **Output parameters:** Latest NFT token ID;

- **Function definition:** getLatestTokenID() view returns (uint256);

- **Example:** 

```groovy
   func TestGetLatestTokenID(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC1155Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.GetLatestTokenID()
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tokenId: %s", tx))
```



<br/>
<br/>
<br/>