#include "type.h"
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

Type* newType(int kind, ...) {
    Type* p = (Type*)malloc(sizeof(Type));
    p->kind = kind;
    return p;
}

Type* newBasicType(int kind) {
    Type* t = newType(BASIC);
    t->u.basic = kind;
    return t;
}

Type* newArrayType(Type* elem, int size) {
    Type* t = newType(ARRAY);
    t->u.array.elem = elem;
    t->u.array.size = size;
    return t;
}

Type* newStructType(char* name, FieldList* member) {
    Type* t = newType(STRUCTURE);
    t->u.structure.name = name ? strdup(name) : NULL;
    t->u.structure.member = member;
    return t;
}

FieldList* newFieldList(char* name, Type* type) {
    FieldList* f = (FieldList*)malloc(sizeof(FieldList));
    f->name = name ? strdup(name) : NULL;
    f->type = type;
    f->next = NULL;
    return f;
}

/* === BONUS: 结构等价检查 (递归比较成员) === */
int checkType(Type* t1, Type* t2) {
    if (t1 == NULL || t2 == NULL) return 1; 
    if (t1->kind != t2->kind) return 0;
    
    switch (t1->kind) {
        case BASIC:
            return t1->u.basic == t2->u.basic;
        case ARRAY:
            return checkType(t1->u.array.elem, t2->u.array.elem);
        case STRUCTURE:
            {
                FieldList* f1 = t1->u.structure.member;
                FieldList* f2 = t2->u.structure.member;
                
                while (f1 && f2) {
                    if (!checkType(f1->type, f2->type)) return 0;
                    f1 = f1->next;
                    f2 = f2->next;
                }
                if (f1 == NULL && f2 == NULL) return 1;
                return 0;
            }
        case FUNCTION:
            return 1; 
    }
    return 1;
}
