#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <unistd.h>
#include "tree.h"
#include "semantic.h"

extern FILE* yyin;
extern void yyrestart(FILE*);
extern int yylineno;
extern int yyparse();
extern struct TreeNode* root;
int error_occurred = 0;

int main(int argc, char** argv) {
    if (argc <= 1) {
        printf("Usage: %s <file_path>\n", argv[0]);
        return 1;
    }

    FILE* f = fopen(argv[1], "r");
    if (!f) {
        perror(argv[1]);
        return 1;
    }

    /* === 1. 生成输出文件名 (.out) === */
    // 分配内存：原文件名长度 + 5个字符 (".out" + \0)
    char* out_filename = (char*)malloc(strlen(argv[1]) + 5);
    strcpy(out_filename, argv[1]);
    
    // 找最后一个点号，替换后缀或追加后缀
    char* dot = strrchr(out_filename, '.');
    if (dot && strcmp(dot, ".bpl") == 0) {
        strcpy(dot, ".out");
    } else {
        strcat(out_filename, ".out");
    }

    /* === 2. 保存当前的控制台输出流 === */
    // dup() 复制文件描述符 1 (stdout) 到一个新的描述符 stdout_copy
    int stdout_copy = dup(fileno(stdout));

    /* === 3. 重定向 stdout 到文件 === */
    // 之后所有的 printf 都会写入 out_filename，而不是屏幕
    if (freopen(out_filename, "w", stdout) == NULL) {
        perror("freopen");
        free(out_filename);
        fclose(f);
        return 1;
    }

    /* === 4. 执行解析与分析 (输出将进入文件) === */
    yylineno = 1;
    yyrestart(f);
    yyparse();

    if (!error_occurred && root != NULL) {
        semantic_analysis(root);
    }

    /* === 5. 恢复 stdout 到控制台 === */
    fflush(stdout);
    dup2(stdout_copy, fileno(stdout));
    close(stdout_copy);

    /* === 6. 读取刚才生成的文件并回显到屏幕 === */
    FILE* f_read = fopen(out_filename, "r");
    if (f_read) {
        char buffer[1024];
        while (fgets(buffer, sizeof(buffer), f_read)) {
            printf("%s", buffer);
        }
        fclose(f_read);
    } else {
        printf("Failed to read back the output file.\n");
    }

    /* === 7. 清理资源 === */
    free(out_filename);
    fclose(f);
    return 0;
}