#ifndef SYMTAB_H
#define SYMTAB_H
#include "type.h"
#define HASH_SIZE 0x8000
typedef struct HashNode_t {
    char* name;
    Type* type;
    int depth; 
    struct HashNode_t* next; 
    struct HashNode_t* stack_next; 
} HashNode;
void initSymbolTable();
int insertSymbol(char* name, Type* type);
HashNode* lookupSymbol(char* name);
void enterScope();
void exitScope();
int inCurrentScope(char* name);
#endif
