#ifndef TREE_H
#define TREE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAX_CHILDREN 16

/* 节点类型：是终结符(TOKEN)还是非终结符(NOT_TOKEN) */
typedef enum { TOKEN, NOT_TOKEN } NodeType;

struct TreeNode {
    NodeType type;          // 节点类型
    char* name;             // 节点名字 (如 "Program", "INT", "ID")
    int lineno;             // 行号
    
    /* 属性值 (根据不同类型存储) */
    union {
        int int_val;        // 存储 INT 的值
        float float_val;    // 存储 FLOAT 的值
        char* str_val;      // 存储 ID 或 TYPE 的字符串
    } value;

    struct TreeNode* children[MAX_CHILDREN]; // 子节点指针数组
    int child_num;                // 子节点数量
};

/* 函数声明 */
struct TreeNode* createNode(char* name, int lineno, NodeType type);
void addChild(struct TreeNode* parent, struct TreeNode* child);
void printTree(struct TreeNode* root, int level);

#endif