#ifndef TYPE_H
#define TYPE_H

#include <stdlib.h>
#include <string.h>

typedef struct Type_t Type;
typedef struct FieldList_t FieldList;

struct Type_t {
    enum { BASIC, ARRAY, STRUCTURE, FUNCTION } kind;
    union {
        int basic; // 0: int, 1: float
        struct { Type* elem; int size; } array; 
        struct { char* name; FieldList* member; } structure; 
        struct { Type* returnType; int paramNum; FieldList* params; } function;
    } u;
};

struct FieldList_t {
    char* name;
    Type* type;
    FieldList* next;
};

Type* newType(int kind, ...); 
Type* newBasicType(int kind);
Type* newArrayType(Type* elem, int size);
Type* newStructType(char* name, FieldList* member);
FieldList* newFieldList(char* name, Type* type);
int checkType(Type* t1, Type* t2);

#endif
