#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <unistd.h>
#include "tree.h"

/* 声明 Flex/Bison 生成的外部变量和函数 */
extern FILE* yyin;
extern void yyrestart(FILE*);
extern int yylineno;
extern int yyparse();

extern struct TreeNode* root;

int error_occurred = 0;

int main(int argc, char** argv) {
    if (argc <= 1) {
        printf("Usage: %s <file_path>\n", argv[0]);
        return 1;
    }

    FILE* f = fopen(argv[1], "r");
    if (!f) {
        perror(argv[1]);
        return 1;
    }
    
    /* === 1. 生成输出文件名 (.out) === */
    char* out_filename = (char*)malloc(strlen(argv[1]) + 5);
    if (!out_filename) {
        fprintf(stderr, "Memory allocation error\n");
        fclose(f);
        return 1;
    }
    strcpy(out_filename, argv[1]);
    char* dot = strrchr(out_filename, '.');
    // 如果后缀是 .bpl 则替换为 .out，否则直接追加 .out
    if (dot && strcmp(dot, ".bpl") == 0) {
        strcpy(dot, ".out");
    } else {
        strcat(out_filename, ".out");
    }

    /* === 2. 重定向 stdout 到文件 === */
    // 保存当前的 stdout 文件描述符 (通常是 1) 以便稍后恢复
    int stdout_copy = dup(fileno(stdout));

    // 使用 freopen 将 stdout 重定向到文件，这样 printTree 中的 printf 会自动写入文件
    FILE* f_out = freopen(out_filename, "w", stdout);
    if (!f_out) {
        perror(out_filename);
        free(out_filename);
        fclose(f);
        return 1;
    }

    /* === 3. 执行解析 === */
    yylineno = 1;      // 重置 Flex 行号
    yyrestart(f);      // 设置 Flex 输入流
    yyparse();         // 开始解析

    /* === 4. 打印语法树 (到文件) === */
    if (!error_occurred && root != NULL) {
        printTree(root, 0);
    }

    /* === 5. 恢复 stdout 并回显 === */
    fflush(stdout); // 确保缓冲区内容已写入文件
    
    // 恢复 stdout 到控制台
    dup2(stdout_copy, fileno(stdout));
    close(stdout_copy);

    // 读取刚才生成的文件内容，并打印到屏幕上 (为了方便调试查看)
    FILE* f_read = fopen(out_filename, "r");
    if (f_read) {
        char buffer[1024];
        while (fgets(buffer, sizeof(buffer), f_read)) {
            printf("%s", buffer);
        }
        fclose(f_read);
    }
    
    // 清理资源
    free(out_filename);
    fclose(f);
    
    return 0;
}