#include "tree.h"
#include "syntax.tab.h"

/* 树节点创建 */
struct TreeNode* createNode(char* name, int lineno, NodeType type) {
    struct TreeNode* node = (struct TreeNode*)malloc(sizeof(struct TreeNode));
    node->name = strdup(name);
    node->lineno = lineno;
    node->type = type;
    node->child_num = 0;
    // 初始化值，防止未定义行为
    node->value.int_val = 0; 
    return node;
}

/* 添加子节点 */
void addChild(struct TreeNode* parent, struct TreeNode* child) {
    // 确保子节点非空且未超过最大子节点数
    if (child != NULL && parent->child_num < MAX_CHILDREN) {
        parent->children[parent->child_num++] = child;
    }
}

/* 打印语法树 */
void printTree(struct TreeNode* root, int level) {
    if (root == NULL) return;

    // 缩进控制：每层 2 个空格
    for (int i = 0; i < level; i++) printf("  ");

    if (root->type == NOT_TOKEN) {
        // 非终结符：打印名字和行号
        printf("%s (%d)\n", root->name, root->lineno);
    } else {
        // 终结符：根据名字打印具体属性
        if (strcmp(root->name, "ID") == 0) {
            printf("ID: %s\n", root->value.str_val);
        } else if (strcmp(root->name, "TYPE") == 0) {
            printf("TYPE: %s\n", root->value.str_val);
        } else if (strcmp(root->name, "INT") == 0) {
            printf("INT: %d\n", root->value.int_val);
        } else if (strcmp(root->name, "FLOAT") == 0) {
            printf("FLOAT: %f\n", root->value.float_val);
        } else if (strcmp(root->name, "CHAR") == 0) { 
            printf("CHAR: %s\n", root->value.str_val); 
        } else {
            // 其他终结符 (如 SEMI, COMMA 等) 直接打印名字
            printf("%s\n", root->name);
        }
    }

    // 递归打印子节点
    for (int i = 0; i < root->child_num; i++) {
        printTree(root->children[i], level + 1);
    }
}