<?php
 namespace blobfolio\wp\duplicity\vendor\common; class data { public static function array_compare(&$arr1, &$arr2) { if (!is_array($arr1) || !is_array($arr2) || count($arr1) !== count($arr2)) { return false; } if (count(array_intersect_key($arr1, $arr2)) !== count($arr1)) { return false; } if (cast::array_type($arr1) !== 'associative' && cast::array_type($arr2) !== 'associative') { return count(array_intersect($arr1, $arr2)) === count($arr1); } foreach ($arr1 as $k=>$v) { if (!isset($arr2[$k])) { return false; } if (is_array($arr1[$k]) && is_array($arr2[$k])) { if (!static::array_compare($arr1[$k], $arr2[$k])) { return false; } } elseif ($arr1[$k] !== $arr2[$k]) { return false; } } return true; } public static function array_idiff($arr1, $arr2) { $arrays = func_get_args(); if (!is_array($arrays) || count($arrays) < 1) { return array(); } foreach ($arrays as $a) { if (!is_array($a)) { return array(); } } for ($x = 1; $x < count($arrays); $x++) { $common = array(); if (!count($arrays[$x])) { continue; } $arr1 = mb::strtolower($arrays[0], true); $arr2 = mb::strtolower($arrays[$x], true); foreach ($arr1 as $k=>$v) { if (!is_array($v) && !in_array($v, $arr2, true)) { $common[$k] = $arrays[0][$k]; } } if (!count($common)) { return $common; } $arrays[0] = $common; } return $arrays[0]; } public static function array_iintersect($arr1, $arr2) { $arrays = func_get_args(); if (!is_array($arrays) || count($arrays) < 2) { return array(); } foreach ($arrays as $a) { if (!is_array($a) || !count($a)) { return array(); } } for ($x = 1; $x < count($arrays); $x++) { $common = array(); $arr1 = mb::strtolower($arrays[0], true); $arr2 = mb::strtolower($arrays[$x], true); foreach ($arr1 as $k=>$v) { if (!is_array($v) && in_array($v, $arr2, true)) { $common[$k] = $arrays[0][$k]; } } if (!count($common)) { return $common; } $arrays[0] = $common; } return $arrays[0]; } public static function array_ikey_exists($needle, $haystack) { if (!is_array($haystack) || !count($haystack)) { return false; } $haystack = array_keys($haystack); return (false !== static::array_isearch($needle, $haystack)); } public static function array_isearch($needle, $haystack, $strict=false) { if (!is_array($haystack) || !count($haystack)) { return false; } ref\mb::strtolower($needle, true); ref\mb::strtolower($haystack, true); ref\cast::to_bool($strict); return array_search($needle, $haystack, $strict); } public static function array_map_recursive(callable $func, array $arr) { return filter_var($arr, FILTER_CALLBACK, array('options'=>$func)); } public static function array_otherize($arr=null, $length=5, $other='Other') { if ('associative' !== cast::array_type($arr)) { return false; } foreach ($arr as $k=>$v) { if (!is_numeric($arr[$k])) { ref\cast::to_float($arr[$k], true); } } arsort($arr); ref\cast::to_int($length, true); ref\sanitize::to_range($length, 1); if (count($arr) <= $length) { return $arr; } ref\cast::to_string($other, true); if (!$other) { $other = 'Other'; } if (1 === $length) { return array($other=>array_sum($arr)); } $out = array_slice($arr, 0, $length - 1); $out[$other] = array_sum(array_slice($arr, $length - 1)); return $out; } public static function array_pop(array &$arr) { if (!count($arr)) { return false; } $reversed = array_reverse($arr); return static::array_pop_top($reversed); } public static function array_pop_rand(array &$arr) { if (!count($arr)) { return false; } if (count($arr) === 1) { return static::array_pop_top($arr); } $keys = array_keys($arr); $index = static::random_int(0, count($arr) - 1); return $arr[$keys[$index]]; } public static function array_pop_top(array &$arr) { if (!count($arr)) { return false; } reset($arr); return $arr[key($arr)]; } public static function cc_exp_months($format='m - M') { ref\cast::to_string($format, true); $months = array(); for ($x = 1; $x <= 12; $x++) { $months[$x] = date($format, strtotime('2000-' . sprintf('%02d', $x) . '-01')); } return $months; } public static function cc_exp_years($length=10) { ref\cast::to_int($length, true); if ($length < 1) { $length = 10; } $years = array(); for ($x = 0; $x < $length; $x++) { $year = (int) (date('Y') + $x); $years[$year] = $year; } return $years; } public static function datediff($date1, $date2) { ref\sanitize::date($date1); ref\sanitize::date($date2); if ( !is_string($date1) || !is_string($date2) || $date1 === $date2 || '0000-00-00' === $date1 || '0000-00-00' === $date2 ) { return 0; } try { $date1 = new \DateTime($date1); $date2 = new \DateTime($date2); $diff = $date1->diff($date2); return abs($diff->days); } catch (\Throwable $e) { $date1 = strtotime($date1); $date2 = strtotime($date2); return ceil(abs($date2 - $date1) / 60 / 60 / 24); } catch (\Exception $e) { $date1 = strtotime($date1); $date2 = strtotime($date2); return ceil(abs($date2 - $date1) / 60 / 60 / 24); } } public static function iin_array($needle, $haystack, $strict=false) { return (false !== static::array_isearch($needle, $haystack, $strict)); } public static function in_range($value, $min=null, $max=null) { return sanitize::to_range($value, $min, $max) === $value; } public static function ip_in_range($ip, $min, $max=null) { ref\sanitize::ip($ip, true); ref\cast::to_string($min); if (!$ip) { return false; } if (false !== strpos($min, '/')) { if (false === ($range = format::cidr_to_range($min))) { return false; } $min = $range['min']; $max = $range['max']; } elseif (is_null($max)) { return false; } ref\format::ip_to_number($ip); ref\format::ip_to_number($min); ref\format::ip_to_number($max); if ( (false !== $ip) && (false !== $min) && (false !== $max) ) { return static::in_range($ip, $min, $max); } return false; } public static function is_json($str, $empty=false) { if (!is_string($str) || (!$empty && !$str)) { return false; } if ($empty && !$str) { return true; } try { $json = json_decode($str); return !is_null($json); } catch (\Throwable $e) { return false; } catch (\Exception $e) { return false; } } public static function is_utf8($str) { try { $str = (string) $str; return (bool) preg_match('//u', $str); } catch (\Throwable $e) { return false; } catch (\Exception $e) { return false; } } public static function json_decode_array($json, $defaults=null, $strict=true, $recursive=true) { ref\format::json_decode($json); if (is_null($json) || (is_string($json) && !$json)) { $json = array(); } else { ref\cast::to_array($json); } if (is_array($defaults)) { return static::parse_args($json, $defaults, $strict, $recursive); } else { return $json; } } public static function length_in_range($str, $min=null, $max=null) { ref\cast::to_string($str, true); if (!is_null($min) && !is_int($min)) { ref\cast::to_int($min, true); } if (!is_null($max) && !is_int($max)) { ref\cast::to_int($max, true); } $length = mb::strlen($str); if (!is_null($min) && !is_null($max) && $min > $max) { static::switcheroo($min, $max); } if (!is_null($min) && $min > $length) { return false; } if (!is_null($max) && $max < $length) { return false; } return true; } public static function parse_args($args, $defaults, $strict=true, $recursive=true) { ref\cast::to_array($args); ref\cast::to_array($defaults); ref\cast::to_bool($strict, true); ref\cast::to_bool($recursive, true); if (!count($defaults)) { return array(); } foreach ($defaults as $k=>$v) { if (array_key_exists($k, $args)) { if ( $recursive && is_array($defaults[$k]) && (cast::array_type($defaults[$k]) === 'associative') ) { $defaults[$k] = static::parse_args($args[$k], $defaults[$k], $strict, $recursive); } else { $defaults[$k] = $args[$k]; if ($strict && !is_null($v)) { ref\cast::to_type($defaults[$k], gettype($v), true); } } } } return $defaults; } public static function random_int($min=0, $max=1) { ref\cast::to_int($min, true); ref\cast::to_int($max, true); if ($min > $max) { static::switcheroo($min, $max); } if (function_exists('random_int')) { return random_int($min, $max); } else { return mt_rand($min, $max); } } public static function random_string($length=10, $soup=null) { ref\cast::to_int($length, true); if (is_array($soup) && count($soup)) { ref\cast::to_string($soup); $soup = implode('', $soup); ref\sanitize::printable($soup); $soup = preg_replace('/\s/u', '', $soup); $soup = array_unique(mb::str_split($soup)); $soup = array_values($soup); if (!count($soup)) { return ''; } } if (!is_array($soup) || !count($soup)) { $soup = constants::RANDOM_CHARS; } if ($length < 1) { return ''; } $salt = ''; $max = count($soup) - 1; for ($x = 0; $x < $length; $x++) { $salt .= $soup[static::random_int(0, $max)]; } return $salt; } public static function switcheroo(&$var1, &$var2) { $tmp = $var1; $var1 = $var2; $var2 = $tmp; return true; } public static function unsetcookie($name, $path='', $domain='', $secure=false, $httponly=false) { ref\cast::to_string($name, true); ref\cast::to_string($path, true); ref\cast::to_string($domain, true); ref\cast::to_bool($secure, true); ref\cast::to_bool($httponly, true); try { setcookie($name, false, -1, $path, $domain, $secure, $httponly); if (isset($_COOKIE[$name])) { unset($_COOKIE[$name]); } } catch (\Throwable $e) { return false; } catch (\Exception $e) { return false; } return true; } } 