<?php
 namespace blobfolio\wp\duplicity\vendor\common; class file { public static function data_uri($path='') { ref\cast::to_string($path, true); ref\file::path($path, true); try { if (false !== $path && is_file($path)) { $content = base64_encode(@file_get_contents($path)); $finfo = mime::finfo($path); return 'data:' . $finfo['mime'] . ';base64,' . $content; } } catch (\Throwable $e) { return false; } catch (\Exception $e) { return false; } return false; } public static function empty_dir($path='') { try { ref\cast::to_string($path); if (!is_readable($path) || !is_dir($path)) { return false; } $handle = opendir($path); while (false !== ($entry = readdir($handle))) { if ('.' !== $entry && '..' !== $entry) { return false; } } } catch (\Throwable $e) { return false; } catch (\Exception $e) { return false; } return true; } public static function leadingslash($path='') { ref\file::leadingslash($path); return $path; } public static function path($path='', $validate=true) { ref\file::path($path, $validate); return $path; } public static function readfile_chunked($file, $retbytes=true) { ref\cast::to_string($file, true); ref\cast::to_bool($retbytes, true); $buffer = ''; $cnt = 0; $chunk_size = 1024 * 1024; if (false === ($handle = fopen($file, 'rb'))) { return false; } while (!feof($handle)) { $buffer = fread($handle, $chunk_size); echo $buffer; ob_flush(); flush(); if ($retbytes) { $cnt += strlen($buffer); } } $status = fclose($handle); if ($retbytes && $status) { return $cnt; } return $status; } public static function redirect(string $to) { ref\sanitize::url($to); unset($_POST); unset($_GET); unset($_REQUEST); if (!headers_sent()) { header("Location: $to"); } else { echo "<script>top.location.href='" . str_replace("'", "\'", $to) . "';</script>"; } exit; } public static function rmdir($path='') { try { ref\file::path($path, true); if (!@is_readable($path) || !@is_dir($path)) { return false; } $handle = opendir($path); while (false !== ($entry = readdir($handle))) { if (('.' === $entry) || ('..' === $entry)) { continue; } $file = "{$path}{$entry}"; if (@is_file($file)) { @unlink($file); } else { static::rmdir($file); } } } catch (\Throwable $e) { return false; } catch (\Exception $e) { return false; } if (static::empty_dir($path)) { @rmdir($path); } return !@file_exists($path); } public static function trailingslash($path='') { ref\file::trailingslash($path); return $path; } public static function unixslash($path='') { ref\file::unixslash($path); return $path; } public static function unleadingslash($path='') { ref\file::unleadingslash($path); return $path; } public static function unparse_url($parsed=null) { $url = ''; $parsed = data::parse_args($parsed, constants::URL_PARTS); $parsed = array_map('trim', $parsed); $parsed = array_filter($parsed, 'strlen'); if (!count($parsed)) { return false; } if (isset($parsed['scheme'])) { $url = "{$parsed['scheme']}:"; } if (isset($parsed['host'])) { if ($url) { $url .= '//'; } if (isset($parsed['user'])) { $url .= $parsed['user']; if (isset($parsed['pass'])) { $url .= ":{$parsed['pass']}"; } $url .= '@'; } $url .= (filter_var($parsed['host'], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) ? "[{$parsed['host']}]" : $parsed['host']); if (isset($parsed['port'])) { $url .= ":{$parsed['port']}"; } if (isset($parsed['path']) && mb::substr($parsed['path'], 0, 1) !== '/') { $url .= '/'; } } if (isset($parsed['path'])) { $url .= $parsed['path']; } if (isset($parsed['query'])) { $url .= "?{$parsed['query']}"; } if (isset($parsed['fragment'])) { $url .= "#{$parsed['fragment']}"; } return $url ? $url : false; } public static function untrailingslash($path='') { ref\file::untrailingslash($path); return $path; } } 