<?php
 namespace blobfolio\wp\duplicity\vendor\common; class format { public static function array_to_indexed($arr) { ref\format::array_to_indexed($arr); return $arr; } public static function ceil($num, $precision=0) { ref\format::ceil($num, $precision); return $num; } public static function cidr_to_range($cidr) { ref\cast::to_string($cidr, true); $range = array('min'=>0, 'max'=>0); $cidr = array_pad(explode('/', $cidr), 2, 0); ref\cast::to_int($cidr[1]); if (filter_var($cidr[0], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) { ref\sanitize::to_range($cidr[1], 0, 32); if (0 === $cidr[1]) { $range['min'] = $range['max'] = sanitize::ip($cidr[0]); } else { $cidr[1] = bindec(str_pad(str_repeat('1', $cidr[1]), 32, '0')); $ip = ip2long($cidr[0]); $netmask = $cidr[1]; $first = ($ip & $netmask); $bc = $first | ~$netmask; $range['min'] = long2ip($first); $range['max'] = long2ip($bc); } return $range; } if (filter_var($cidr[0], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) { ref\sanitize::to_range($cidr[1], 0, 128); if (0 === $cidr[1]) { $range['min'] = $range['max'] = sanitize::ip($cidr[0]); return $range; } $bin = str_pad(str_repeat('1', $cidr[1]), 128, '0'); if (function_exists('gmp_init')) { $cidr[1] = gmp_strval(gmp_init($bin, 2), 10); } else { $cidr[1] = bc::bindec($bin); } $ip = static::ip_to_number($cidr[0]); $netmask = $cidr[1]; if (function_exists('gmp_and')) { $first = gmp_and($ip, $netmask); $bin = gmp_strval(gmp_init($netmask, 10), 2); $bin = sprintf('%0128s', $bin); $bin = strtr($bin, array('0'=>'1', '1'=>'0')); $not = gmp_strval(gmp_init($bin, 2), 10); $bc = gmp_or($first, $not); } else { $first = bc::bitwise('&', $ip, $netmask); $bc = bc::bitwise('|', $first, bc::bitwise('~', $netmask, null, 128)); } $range['min'] = static::number_to_ip($first); $range['max'] = static::number_to_ip($bc); return $range; } return false; } public static function decode_js_entities($str='') { ref\format::decode_js_entities($str); return $str; } public static function decode_escape_entities($str='') { ref\format::decode_escape_entities($str); return $str; } public static function decode_unicode_entities($str='') { ref\format::decode_unicode_entities($str); return $str; } public static function decode_entities($str='') { ref\format::decode_entities($str); return $str; } public static function excerpt($str='', $args=null) { ref\cast::to_string($str, true); ref\sanitize::whitespace($str); $str = strip_tags($str); $options = data::parse_args($args, constants::EXCERPT); if ($options['length'] < 1) { return ''; } $options['unit'] = strtolower($options['unit']); switch (substr($options['unit'], 0, 4)) { case 'char': $options['unit'] = 'character'; break; case 'word': $options['unit'] = 'word'; break; } if (('character' === $options['unit']) && mb::strlen($str) > $options['length']) { $str = trim(mb::substr($str, 0, $options['length'])) . $options['suffix']; } elseif (('word' === $options['unit']) && mb::substr_count($str, ' ') > $options['length'] - 1) { $str = explode(' ', $str); $str = array_slice($str, 0, $options['length']); $str = implode(' ', $str) . $options['suffix']; } return $str; } public static function floor($num, $precision=0) { ref\format::floor($num, $precision); return $num; } public static function inflect($count, $single, $plural) { ref\cast::to_string($single, true); ref\cast::to_string($plural, true); if (is_array($count)) { $count = (float) count($count); } else { ref\cast::to_number($count); } ref\sanitize::utf8($single); ref\sanitize::utf8($plural); if (1.0 === $count) { return sprintf($single, $count); } else { return sprintf($plural, $count); } } public static function ip_to_number($ip) { ref\format::ip_to_number($ip); return $ip; } public static function ip_to_subnet($ip) { ref\format::ip_to_subnet($ip); return $ip; } public static function json($str='', $pretty=true) { ref\format::json($str, $pretty); return $str; } public static function json_decode($str='') { ref\format::json_decode($str); return $str; } public static function links($str, $args=null, $pass=1) { ref\format::links($str, $args, $pass); return $str; } public static function list_to_array($list, $args=null) { ref\format::list_to_array($list, $args); return $list; } public static function money($value=0, $cents=false, $separator='', $no00=false) { ref\format::money($value, $cents, $separator, $no00); return $value; } public static function number_to_ip($ip) { ref\format::number_to_ip($ip); return $ip; } public static function phone($str='', $country='', $types=array()) { ref\format::phone($str, $country, $types); return $str; } public static function round($num, $precision=0, $mode=PHP_ROUND_HALF_UP) { ref\format::round($num, $precision, $mode); return $num; } public static function to_csv($data=null, $headers=null, $delimiter=',', $eol="\n") { ref\cast::to_array($data); $data = array_values(array_filter($data, 'is_array')); ref\cast::to_array($headers); ref\cast::to_string($delimiter, true); ref\cast::to_string($eol, true); $out = array(); if (!count($headers) && count($data) && cast::array_type($data[0]) === 'associative') { $headers = array_keys($data[0]); } if (count($headers)) { foreach ($headers as $k=>$v) { ref\cast::to_string($headers[$k], true); } ref\sanitize::csv($headers); $out[] = '"' . implode('"' . $delimiter . '"', $headers) . '"'; } if (count($data)) { foreach ($data as $line) { foreach ($line as $k=>$v) { ref\cast::to_string($line[$k], true); } ref\sanitize::csv($line); $out[] = '"' . implode('"' . $delimiter . '"', $line) . '"'; } } return implode($eol, $out); } public static function to_timezone($date, $from='UTC', $to='UTC') { ref\format::to_timezone($date, $from, $to); return $date; } public static function to_xls($data=null, $headers=null) { ref\cast::to_array($data); $data = array_values(array_filter($data, 'is_array')); ref\cast::to_array($headers); $out = array( '<?xml version="1.0" encoding="UTF-8"?><?mso-application progid="Excel.Sheet"?>', '<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" xmlns:html="http://www.w3.org/TR/REC-html40">', '<Styles>', '<Style ss:ID="s0">', '<NumberFormat ss:Format="True/False"/>', '</Style>', '<Style ss:ID="s1">', '<NumberFormat ss:Format="General Date"/>', '</Style>', '<Style ss:ID="s2">', '<NumberFormat ss:Format="Short Date"/>', '</Style>', '<Style ss:ID="s3">', '<NumberFormat ss:Format="Long Time"/>', '</Style>', '<Style ss:ID="s4">', '<NumberFormat ss:Format="Percent"/>', '</Style>', '<Style ss:ID="s5">', '<NumberFormat ss:Format="Currency"/>', '</Style>', '</Styles>', '<Worksheet>', '<Table>', '<Column ss:Index="1" ss:AutoFitWidth="0" ss:Width="110"/>' ); if (!count($headers) && count($data) && cast::array_type($data[0]) === 'associative') { $headers = array_keys($data[0]); } if (count($headers)) { foreach ($headers as $k=>$v) { ref\cast::to_string($headers[$k], true); } $out[] = '<Row>'; foreach ($headers as $cell) { $cell = htmlspecialchars(strip_tags(sanitize::quotes(sanitize::whitespace($cell))), ENT_XML1 | ENT_NOQUOTES, 'UTF-8'); $out[] = '<Cell><Data ss:Type="String"><b>' . $cell . '</b></Data></Cell>'; } $out[] = '</Row>'; } if (count($data)) { foreach ($data as $line) { $out[] = '<Row>'; foreach ($line as $cell) { $type = gettype($cell); $format = null; if ('boolean' === $type || 'bool' === $type) { $type = 'Boolean'; $format = '0'; $cell = $cell ? 1 : 0; } elseif (is_numeric($cell)) { $type = 'Number'; ref\cast::to_number($cell); } else { ref\cast::to_string($cell, true); ref\sanitize::whitespace($cell, 2); if (preg_match('/^\d{4}\-\d{2}\-\d{2} \d{2}:\d{2}:\d{2}$/', $cell)) { $type = 'DateTime'; $format = '1'; $cell = str_replace(' ', 'T', $cell); } elseif (preg_match('/^\d{4}\-\d{2}\-\d{2}$/', $cell)) { $type = 'DateTime'; $format = '2'; $cell .= 'T00:00:00'; } elseif (preg_match('/^\d{2}:\d{2}(:\d{2})?$/', $cell)) { $type = 'DateTime'; $format = '3'; $cell = "0000-00-00T$cell"; if (mb::substr_count($cell, ':') === 2) { $cell .= ':00'; } } elseif (preg_match('/^\-?[\d,]*\.?\d+%$/', $cell)) { $type = 'Number'; $format = '4'; ref\cast::to_number($cell); } elseif (preg_match('/^\-\$?[\d,]*\.?\d+$/', $cell) || preg_match('/^\-?[\d,]*\.?\d+¢$/', $cell)) { $type = 'Number'; $format = '5'; ref\cast::to_number($cell); } else { $type = 'String'; $cell = htmlspecialchars(strip_tags(sanitize::quotes($cell)), ENT_XML1 | ENT_NOQUOTES, 'UTF-8'); } } $out[] = '<Cell' . (!is_null($format) ? ' ss:StyleID="s' . $format . '"' : '') . '><Data ss:Type="' . $type . '">' . $cell . '</Data></Cell>'; } $out[] = '</Row>'; } } $out[] = '</Table>'; $out[] = '</Worksheet>'; $out[] = '</Workbook>'; return implode("\r\n", $out); } } 