<?php
 namespace blobfolio\wp\duplicity\vendor\common\ref; use \blobfolio\wp\duplicity\vendor\common\bc; use \blobfolio\wp\duplicity\vendor\common\constants; use \blobfolio\wp\duplicity\vendor\common\data; use \blobfolio\wp\duplicity\vendor\common\file as v_file; use \blobfolio\wp\duplicity\vendor\common\format as v_format; use \blobfolio\wp\duplicity\vendor\common\mb as v_mb; use \blobfolio\wp\duplicity\vendor\common\sanitize as v_sanitize; use \blobfolio\wp\duplicity\vendor\domain\domain; class format { public static function array_to_indexed(&$arr) { cast::to_array($arr); if (count($arr)) { $out = array(); foreach ($arr as $k=>$v) { $out[] = array( 'key'=>$k, 'value'=>$v, ); } $arr = $out; } return true; } public static function ceil(&$num, $precision=0) { if (is_array($num)) { foreach ($num as $k=>$v) { static::ceil($num[$k], $precision); } } else { cast::to_float($num, true); cast::to_int($precision, true); sanitize::to_range($precision, 0); $precision = (10 ** $precision); $num = ceil($num * $precision) / $precision; } return true; } public static function decode_js_entities(&$str='') { cast::to_string($str, true); static::decode_unicode_entities($str); static::decode_escape_entities($str); return true; } public static function decode_escape_entities(&$str='') { cast::to_string($str, true); $replacements = array( '\b'=>chr(0x08), '\f'=>chr(0x0C), '\n'=>chr(0x0A), '\r'=>chr(0x0D), '\t'=>chr(0x09), ); $str = str_replace( array_keys($replacements), array_values($replacements), $str ); return true; } public static function decode_unicode_entities(&$str='') { cast::to_string($str, true); $last = ''; while ($str !== $last) { $last = $str; $str = preg_replace_callback( '/\\\u([0-9A-Fa-f]{4})/u', array(get_called_class(), 'decode_entities_hex'), $str ); cast::to_string($str, true); } return true; } public static function decode_entities(&$str='') { cast::to_string($str, true); $last = ''; while ($str !== $last) { $last = $str; $str = html_entity_decode($str, ENT_QUOTES, 'UTF-8'); $str = preg_replace_callback('/&#([0-9]+);/', array(get_called_class(), 'decode_entities_chr'), $str); $str = preg_replace_callback('/&#[Xx]([0-9A-Fa-f]+);/', array(get_called_class(), 'decode_entities_hex'), $str); cast::to_string($str, true); } return true; } protected static function decode_entities_chr($matches) { return chr($matches[1]); } protected static function decode_entities_hex($matches) { return chr(hexdec($matches[1])); } public static function floor(&$num, $precision=0) { if (is_array($num)) { foreach ($num as $k=>$v) { static::floor($num[$k], $precision); } } else { cast::to_float($num, true); cast::to_int($precision, true); sanitize::to_range($precision, 0); $precision = (10 ** $precision); $num = floor($num * $precision) / $precision; } return true; } public static function ip_to_number(&$ip) { cast::to_string($ip, true); if (!filter_var($ip, FILTER_VALIDATE_IP)) { $ip = false; return false; } if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) { $ip = ip2long($ip); return true; } if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) { try { $ip_n = inet_pton($ip); $bin = ''; $length = strlen($ip_n) - 1; for ($bit = $length; $bit >= 0; $bit--) { $bin = sprintf('%08b', ord($ip_n[$bit])) . $bin; } if (function_exists('gmp_init')) { $ip = gmp_strval(gmp_init($bin, 2), 10); return true; } $ip = bc::bindec($bin); return true; } catch (\Throwable $e) { $ip = false; return false; } catch (\Exception $e) { $ip = false; return false; } } $ip = false; return false; } public static function ip_to_subnet(&$ip) { sanitize::ip($ip, true, false); if (!$ip) { $ip = false; return false; } elseif (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) { $bits = explode('.', $ip); $bits[3] = 0; $ip = implode('.', $bits) . '/24'; } else { $bits = explode(':', $ip); for ($x = 4; $x <= 7; $x++) { $bits[$x] = 0; } $ip = v_sanitize::ip(implode(':', $bits), true) . '/64'; } return true; } public static function json(&$str='', $pretty=true) { if (!is_string($str)) { sanitize::utf8($str); $str = json_encode($str); } if (false === ($decode = v_format::json_decode($str))) { $str = null; return false; } if ($pretty) { $str = json_encode($decode, JSON_PRETTY_PRINT); } else { $str = json_encode($decode); } return true; } public static function json_decode(&$str='') { cast::to_string($str, true); $str = preg_replace( array( '#^\s*//(.+)$#m', '#^\s*/\*(.+)\*/#Us', '#/\*(.+)\*/\s*$#Us', ), '', $str ); mb::trim($str); if (!$str || ("''" === $str) || ('""' === $str)) { $str = ''; return true; } $tmp = json_decode($str, true); if (!is_null($tmp)) { $str = $tmp; return true; } $lower = v_mb::strtolower($str); if ('true' === $lower || 'false' === $lower) { cast::to_bool($str); return true; } elseif ('null' === $lower) { $str = null; return true; } elseif (is_numeric($lower)) { if (false !== strpos($lower, '.')) { $str = (float) $lower; } else { $str = (int) $lower; } return true; } elseif (preg_match('/^("|\')(.+)(\1)$/s', $str, $match) && $match[1] === $match[3]) { $str = $match[2]; static::decode_js_entities($str); return true; } elseif (!preg_match('/^\[.*\]$/s', $str) && !preg_match('/^\{.*\}$/s', $str)) { $str = null; return false; } $slices = array( array( 'type'=>'slice', 'from'=>0, 'delimiter'=>false, ), ); $out = array(); if (0 === v_mb::strpos($str, '[')) { $type = 'array'; } else { $type = 'object'; } $chunk = v_mb::substr($str, 1, -1); $length = v_mb::strlen($chunk); for ($x = 0; $x <= $length; $x++) { $last = end($slices); $subchunk = v_mb::substr($chunk, $x, 2); if ( ($x === $length) || ((',' === $chunk{$x}) && 'slice' === $last['type']) ) { $slice = v_mb::substr($chunk, $last['from'], ($x - $last['from'])); $slices[] = array( 'type'=>'slice', 'from'=>$x + 1, 'delimiter'=>false, ); if ('array' === $type) { $out[] = v_format::json_decode($slice); } else { if (preg_match('/^\s*(["\'].*[^\\\]["\'])\s*:\s*(\S.*),?$/Uis', $slice, $parts)) { $key = v_format::json_decode($parts[1]); $val = v_format::json_decode($parts[2]); $out[$key] = $val; } elseif (preg_match('/^\s*(\w+)\s*:\s*(\S.*),?$/Uis', $slice, $parts)) { $key = $parts[1]; static::decode_js_entities($key); $val = v_format::json_decode($parts[2]); $out[$key] = $val; } } } elseif ( (('"' === $chunk{$x}) || ("'" === $chunk{$x})) && ('string' !== $last['type']) ) { $slices[] = array( 'type'=>'string', 'from'=>$x, 'delimiter'=>$chunk{$x}, ); } elseif ( ($chunk{$x} === $last['delimiter']) && ('string' === $last['type']) && ('\\' !== $chunk{$x - 1} || (('\\' === $chrs{$c - 1}) && '\\' === $chunk{$x - 2})) ) { array_pop($slices); } elseif ( ('[' === $chunk{$x}) && in_array($last['type'], array('slice', 'array', 'object'), true) ) { $slices[] = array( 'type'=>'array', 'from'=>$x, 'delimiter'=>false, ); } elseif ( (']' === $chunk{$x}) && ('array' === $last['type']) ) { array_pop($slices); } elseif ( ('{' === $chunk{$x}) && in_array($last['type'], array('slice', 'array', 'object'), true) ) { $slices[] = array( 'type'=>'object', 'from'=>$x, 'delimiter'=>false, ); } elseif ( ('}' === $chunk{$x}) && ('object' === $last['type']) ) { array_pop($slices); } elseif ( ('/*' === $subchunk) && in_array($last['type'], array('slice', 'array', 'object'), true) ) { $slices[] = array( 'type'=>'comment', 'from'=>$x, 'delimiter'=>false, ); $x++; } elseif ( ('/*' === $subchunk) && ('comment' === $last['type']) ) { array_pop($slices); $x++; for ($y = $last['from']; $y <= $x; $y++) { $chunk{$y} = ' '; } } } $str = $out; return true; } public static function links(&$str, $args=null, $pass=1) { cast::to_string($str, true); cast::to_int($pass, true); $defaults = array( 'class'=>array(), 'rel'=>'', 'target'=>'', ); $data = data::parse_args($args, $defaults); $data['class'] = implode(' ', $data['class']); sanitize::html($data); $data = array_filter($data, 'strlen'); $atts = array(); foreach ($data as $k=>$v) { $atts[] = "$k=\"$v\""; } $atts = implode(' ', $atts); $str = preg_split('/(<.+?>)/is', $str, 0, PREG_SPLIT_DELIM_CAPTURE); $blacklist = implode('|', constants::LINKS_BLACKLIST); $ignoring = false; foreach ($str as $k=>$v) { if (0 === $k % 2) { if (false !== $ignoring) { continue; } if (1 === $pass) { $str[$k] = preg_replace_callback( '/((ht|f)tps?:\/\/[^\s\'"\[\]\(\){}]+|[^\s\'"\[\]\(\){}]*xn--[^\s\'"\[\]\(\){}]+|[@]?[\w\.]+\.[\w\.]{2,}[^\s]*)/ui', function($matches) use($atts) { $raw = $matches[1]; if (0 === v_mb::strpos($raw, '@')) { return $matches[1]; } if (preg_match('/([^\w\/]+)$/ui', $raw, $suffix)) { $suffix = $suffix[1]; $raw = preg_replace('/([^\w\/]+)$/ui', '', $raw); } else { $suffix = ''; } $link = v_mb::parse_url($raw); if (!is_array($link) || !isset($link['host'])) { return $matches[1]; } $domain = new domain($link['host']); if (!$domain->is_valid() || !$domain->is_fqdn()) { return $matches[1]; } if (!isset($link['scheme'])) { $link['scheme'] = 'http'; } $link = v_file::unparse_url($link); if (filter_var($link, FILTER_SANITIZE_URL) !== $link) { return $matches[1]; } sanitize::html($link); return '<a href="' . $link . '"' . ($atts ? " $atts" : '') . '>' . $raw . '</a>' . $suffix; }, $str[$k] ); } elseif (2 === $pass) { $str[$k] = preg_replace_callback( '/([\w\.\!#\$%&\*\+\=\?_~]+@[^\s\'"\[\]\(\){}@]{2,})/ui', function($matches) use($atts) { $raw = $matches[1]; if (preg_match('/([^\w]+)$/ui', $raw, $suffix)) { $suffix = $suffix[1]; $raw = preg_replace('/([^\w]+)$/ui', '', $raw); } else { $suffix = ''; } $link = v_sanitize::email($raw); if (!$link) { return $matches[1]; } sanitize::html($link); return '<a href="mailto:' . $link . '"' . ($atts ? " $atts" : '') . '>' . $raw . '</a>' . $suffix; }, $str[$k] ); } elseif (3 === $pass) { $str[$k] = preg_replace_callback( '/(\s)?(\+\d[\d\-\s]{5,}+|\(\d{3}\)\s[\d]{3}[\-\.\s]\d{4}|\d{3}[\-\.\s]\d{3}[\-\.\s]\d{4}|\+\d{7,})/ui', function($matches) use($atts) { $prefix = $matches[1]; $raw = $matches[2]; if (preg_match('/([^\d]+)$/ui', $raw, $suffix)) { $suffix = $suffix[1]; $raw = preg_replace('/([^\d]+)$/ui', '', $raw); } else { $suffix = ''; } $link = v_format::phone($raw); $link = preg_replace('/[^\d]/', '', $link); if (!$link) { return $matches[1] . $matches[2]; } return $prefix . '<a href="tel:+' . $link . '"' . ($atts ? " $atts" : '') . '>' . $raw . '</a>' . $suffix; }, $str[$k] ); } } else { if (false === $ignoring) { if (preg_match("/<($blacklist).*(?<!\/)>$/is", $str[$k], $matches)) { $ignoring = preg_quote($matches[1], '/'); } } elseif (preg_match("/<\/\s*$ignoring>/i", $str[$k], $matches)) { $ignoring = false; } } } $str = implode($str); if (1 === $pass) { static::links($str, $args, 2); } elseif (2 === $pass) { static::links($str, $args, 3); } return true; } public static function list_to_array(&$list, $args=null) { $out = array(); if (is_string($args)) { $args = array('delimiter'=>$args); } $args = data::parse_args($args, constants::LIST_TO_ARRAY); $args['cast'] = strtolower($args['cast']); if ( ('array' === $args['cast']) || !array_key_exists($args['cast'], constants::CAST_TYPES) ) { $args['cast'] = 'string'; } if (!is_null($args['min']) && !is_null($args['max']) && $args['min'] > $args['max']) { data::switcheroo($args['min'], $args['max']); } cast::to_array($list); foreach ($list as $k=>$v) { if (is_array($list[$k])) { static::list_to_array($list[$k], $args); } else { cast::to_string($list[$k], true); if ($args['delimiter']) { $list[$k] = explode($args['delimiter'], $list[$k]); } else { $list[$k] = mb::str_split($list[$k]); } if ($args['trim']) { mb::trim($list[$k]); } $list[$k] = array_filter($list[$k], 'strlen'); if ('string' !== $args['cast']) { cast::to_type($list[$k], $args['cast']); } } foreach ($list[$k] as $v2) { if ( (is_null($args['min']) || $v2 >= $args['min']) && (is_null($args['max']) || $v2 <= $args['max']) ) { $out[] = $v2; } } } if ($args['unique'] && count($out)) { $out = array_values(array_unique($out)); } if ($args['sort'] && count($out)) { sort($out); } $list = $out; return true; } public static function money(&$value=0, $cents=false, $separator='', $no00=false) { if (is_array($value)) { foreach ($value as $k=>$v) { static::money($value[$k], $cents, $separator, $no00); } } else { cast::to_float($value); cast::to_bool($cents, true); cast::to_string($separator, true); cast::to_bool($no00, true); $value = round($value, 2); $negative = $value < 0; if ($negative) { $value = abs($value); } if ($value >= 1 || false === $cents) { $value = ($negative ? '-' : '') . '$' . number_format($value, 2, '.', $separator); if ($no00) { $value = preg_replace('/\.00$/', '', $value); } } else { $value = ($negative ? '-' : '') . (100 * $value) . '¢'; } } return true; } public static function number_to_ip(&$ip) { cast::to_string($ip, true); if (!$ip || ('0' === $ip)) { $ip = false; return false; } if (function_exists('gmp_init')) { $bin = gmp_strval(gmp_init($ip, 10), 2); $bin = sprintf('%0128s', $bin); } else { $bin = bc::decbin($ip, 128); } $chunk = array(); for ($bit = 0; $bit <= 7; $bit++) { $bin_part = substr($bin, $bit * 16, 16); $chunk[] = dechex(bindec($bin_part)); } $ip = implode(':', $chunk); $ip = inet_ntop(inet_pton($ip)); if (!$ip || '::' === $ip) { $ip = '0.0.0.0'; } sanitize::ip($ip, true); return true; } public static function phone(&$str='', $country='', $types=array()) { if (is_array($str)) { foreach ($str as $k=>$v) { static::phone($str[$k], $country, $types); } } else { cast::to_string($str); sanitize::whitespace($str); if (!$str) { $str = ''; return false; } cast::to_string($country); cast::to_array($types); $str = new phone($str, $country); if (!$str->is_phone($types)) { $str = ''; return false; } $str = (string) $str; } return true; } public static function round(&$num, $precision=0, $mode=PHP_ROUND_HALF_UP) { if (is_array($num)) { foreach ($num as $k=>$v) { static::round($num[$k], $precision, $mode); } } else { cast::to_float($num, true); cast::to_int($precision, true); sanitize::to_range($precision, 0); $num = round($num, $precision, $mode); } return true; } public static function to_timezone(&$date, $from='UTC', $to='UTC') { cast::to_string($date, true); cast::to_string($from, true); cast::to_string($to, true); sanitize::datetime($date); if ('UTC' !== $from) { sanitize::timezone($from); } if ('UTC' !== $to) { sanitize::timezone($to); } if ('0000-00-00 00:00:00' === $date || $from === $to) { return true; } $original = $date; try { $date_new = new \DateTime($date, new \DateTimeZone($from)); $date_new->setTimezone(new \DateTimeZone($to)); $date = $date_new->format('Y-m-d H:i:s'); } catch (\Throwable $e) { $date = $original; } catch (\Exception $e) { $date = $original; } return true; } } 