<?php
 namespace blobfolio\wp\duplicity\vendor\domain; use \blobfolio\wp\duplicity\vendor\common; class domain { const HOST_PARTS = array( 'host'=>null, 'subdomain'=>null, 'domain'=>null, 'suffix'=>null, ); protected $host; protected $subdomain; protected $domain; protected $suffix; protected $dns; public function __construct($host='', $www=false) { common\ref\cast::to_bool($www, true); if (false === ($parsed = static::parse_host_parts($host))) { return false; } $this->host = $parsed['host']; $this->subdomain = $parsed['subdomain']; $this->domain = $parsed['domain']; $this->suffix = $parsed['suffix']; if ($www) { $this->strip_www(); } return true; } public static function parse_host($host) { $tmp = common\mb::parse_url($host, PHP_URL_HOST); if ($tmp) { $host = $tmp; } else { common\ref\cast::to_string($host, true); common\ref\mb::trim($host); if (false !== ($start = common\mb::strpos($host, '/'))) { $host = common\mb::substr($host, 0, $start); } if (false !== ($start = common\mb::strpos($host, '?'))) { $host = common\mb::substr($host, 0, $start); } if (false !== ($start = common\mb::strpos($host, '@'))) { $host = common\mb::substr($host, $start + 1); } if (filter_var($host, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) { common\ref\sanitize::ip($host, true); } elseif ( 0 === common\mb::strpos($host, '[') && false !== ($end = common\mb::strpos($host, ']')) ) { $host = common\mb::substr($host, 1, $end - 1); common\ref\sanitize::ip($host, true); } elseif (false !== ($start = common\mb::strpos($host, ':'))) { $host = common\mb::substr($host, 0, $start); } if (!strlen($host)) { return false; } if (function_exists('idn_to_ascii')) { $host = explode('.', $host); $host = array_map('idn_to_ascii', $host); $host = implode('.', $host); } common\ref\mb::strtolower($host); $host = ltrim($host, '.'); $host = rtrim($host, '.'); } if (0 === common\mb::strpos($host, '[')) { $host = str_replace(array('[', ']'), '', $host); common\ref\sanitize::ip($host, true); } if (filter_var($host, FILTER_VALIDATE_IP)) { return $host; } if (preg_match('/[^a-z\d\-\.]/u', $host)) { return false; } $host = explode('.', $host); foreach ($host as $v) { if ( !strlen($v) || '-' === substr($v, 0, 1) || '-' === substr($v, -1) ) { return false; } } return implode('.', $host); } public static function parse_host_parts($host) { if (false === ($host = static::parse_host($host))) { return false; } $out = static::HOST_PARTS; if (filter_var($host, FILTER_VALIDATE_IP)) { $out['host'] = $host; $out['domain'] = $host; return $out; } $suffixes = data::SUFFIXES; $suffix = array(); $parts = explode('.', $host); $parts = array_reverse($parts); foreach ($parts as $k=>$part) { if (isset($suffixes[$part]) && isset($suffixes[$part]['!'])) { break; } if (isset($suffixes[$part])) { array_unshift($suffix, $part); $suffixes = $suffixes[$part]; unset($parts[$k]); continue; } if (isset($suffixes['*'])) { array_unshift($suffix, $part); $suffixes = $suffixes['*']; unset($parts[$k]); continue; } break; } if (!count($parts)) { return false; } $parts = array_reverse($parts); $out['domain'] = array_pop($parts); if (count($parts)) { $out['subdomain'] = implode('.', $parts); } if (count($suffix)) { $out['suffix'] = implode('.', $suffix); } $out['host'] = $host; return $out; } public function strip_www() { if (!$this->is_valid() || is_null($this->subdomain)) { return false; } if ( 'www' === $this->subdomain || 'www.' === common\mb::substr($this->subdomain, 0, 4) ) { $this->subdomain = preg_replace('/^www\.?/u', '', $this->subdomain); if (!strlen($this->subdomain)) { $this->subdomain = null; } $this->host = preg_replace('/^www\./u', '', $this->host); return true; } return false; } public function is_valid($dns=false) { common\ref\cast::to_bool($dns, true); return !is_null($this->host) && (!$dns || $this->has_dns()); } public function is_fqdn() { return ( $this->is_valid() && (is_string($this->suffix) || $this->is_ip(false)) ); } public function is_ip($restricted=true) { common\ref\cast::to_bool($restricted, true); if (!$this->is_valid()) { return false; } if ($restricted) { return !!filter_var($this->host, FILTER_VALIDATE_IP); } return !!filter_var($this->host, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE); } public function has_dns() { if (is_null($this->dns)) { if (!$this->is_fqdn()) { $this->dns = false; } elseif ($this->is_ip()) { $this->dns = $this->is_ip(false); } else { $this->dns = !!filter_var(gethostbyname("{$this->host}."), FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE); } } return $this->dns; } public function is_ascii() { if (!$this->is_valid()) { return false; } return !$this->is_unicode(); } public function is_unicode() { if (!$this->is_valid() || $this->is_ip() || !function_exists('idn_to_utf8')) { return false; } return ($this->to_unicode('host') !== $this->host); } public function __toString() { return $this->is_valid() ? $this->host : ''; } public function __call($method, $args) { preg_match_all('/^get_(.+)$/', $method, $matches); if ( count($matches[0]) && 'dns' !== $matches[1][0] && property_exists($this, $matches[1][0]) ) { $variable = $matches[1][0]; if (is_array($args) && count($args)) { $args = common\data::array_pop_top($args); common\ref\cast::to_bool($args); if ($args) { return $this->to_unicode($variable); } } return $this->{$variable}; } throw new \Exception(sprintf('The required method "%s" does not exist for %s', $method, get_called_class())); } protected function to_unicode($key) { $value = $this->{$key}; if (function_exists('idn_to_utf8') && is_string($value)) { $value = explode('.', $value); $value = array_map('idn_to_utf8', $value); return implode('.', $value); } return $value; } public function get_data($unicode=false) { common\ref\cast::to_bool($unicode, true); if (!$this->is_valid()) { return false; } return array( 'host'=>$this->get_host($unicode), 'subdomain'=>$this->get_subdomain($unicode), 'domain'=>$this->get_domain($unicode), 'suffix'=>$this->get_suffix($unicode), ); } } 