<?php
 namespace blobfolio\wp\musty\vendor\common; class file { public static function copy(string $from, string $to) { ref\file::path($from, true); if (!$from) { return false; } ref\file::path($to, false); if (!$to || ($from === $to)) { return false; } if (@is_dir($from)) { ref\file::trailingslash($from, true); ref\file::trailingslash($to, true); if (!@is_dir($to)) { $dir_chmod = (@fileperms($from) & 0777 | 0755); if (!static::mkdir($to, $dir_chmod)) { return false; } } if ($handle = @opendir($from)) { while (false !== ($file = @readdir($handle))) { if (('.' === $file) || ('..' === $file)) { continue; } static::copy("{$from}{$file}", "{$to}{$file}"); } closedir($handle); } return true; } elseif (@is_file($from)) { $dir_from = dirname($from); $dir_to = dirname($to); if (!@is_dir($dir_to)) { $dir_chmod = (@fileperms($dir_from) & 0777 | 0755); if (!static::mkdir($dir_to, $dir_chmod)) { return false; } } if (!@copy($from, $to)) { return false; } $file_chmod = (@fileperms($from) & 0777 | 0644); @chmod($to, $file_chmod); return true; } return false; } public static function csv_headers(string $csv, $cols=false, string $delimiter=',') { ref\file::path($csv, true); if (!$csv || !@is_file($csv)) { return false; } $assoc = false; if (is_array($cols) && count($cols)) { if ('associative' === cast::array_type($cols)) { $assoc = true; } $cols = array_flip($cols); } else { $cols = false; } if ($handle = @fopen($csv, 'r')) { while (false !== ($line = @fgetcsv($handle, 0, $delimiter))) { if (!isset($line[0])) { continue; } $line = array_flip($line); if (!$cols) { foreach ($line as $k=>$v) { $line[$k] = (int) $v; } return $line; } $out = array(); foreach ($cols as $k=>$v) { $key = $assoc ? $v : $k; $value = isset($line[$k]) ? (int) $line[$k] : false; $out[$key] = $value; } return $out; } @fclose($handle); } return false; } public static function data_uri(string $path, bool $constringent=false) { ref\cast::constringent($path, $constringent); ref\file::path($path, true, true); if ((false !== $path) && @is_file($path)) { $content = base64_encode(@file_get_contents($path)); $finfo = mime::finfo($path); return "data:{$finfo['mime']};base64,{$content}"; } return false; } public static function dirsize(string $path) { $size = 0; $files = static::scandir($path, true, false); foreach ($files as $v) { $size += @filesize($v); } return $size; } public static function empty_dir(string $path) { ref\cast::string($path); if (!@is_readable($path) || !@is_dir($path)) { return false; } if ($handle = @opendir($path)) { while (false !== ($file = @readdir($handle))) { if (('.' !== $file) && ('..' !== $file)) { return false; } } closedir($handle); return true; } return false; } public static function hash_dir($path, string $dir_algo='md5', string $file_algo=null) { if (!$dir_algo || !in_array($dir_algo, hash_algos(), true)) { return false; } if (!$file_algo || !in_array($file_algo, hash_algos(), true)) { $file_algo = $dir_algo; } $files = static::scandir($path, true, false); if (!count($files)) { return hash($dir_algo, 'empty'); } $soup = ''; foreach ($files as $v) { $soup .= hash_file($file_algo, $v); } return hash($dir_algo, $soup); } public static function idn_to_ascii($url) { ref\file::idn_to_ascii($url); return $url; } public static function idn_to_utf8($url) { ref\file::idn_to_utf8($url); return $url; } public static function leadingslash($path, bool $constringent=false) { ref\file::leadingslash($path, $constringent); return $path; } public static function line_count(string $file, bool $trim=true) { if (!$file || !@is_file($file)) { return false; } $lines = 0; if ($handle = @fopen($file, 'r')) { while (false !== ($line = @fgets($handle))) { if ($trim) { if (trim($line)) { ++$lines; } } else { ++$lines; } } @fclose($handle); } return $lines; } public static function mkdir(string $path, $chmod=null) { if (!$chmod || !is_numeric($chmod)) { $chmod = (fileperms(__DIR__) & 0777 | 0755); } ref\file::path($path, false); if (!$path || (false !== strpos($path, '://'))) { return false; } if (!@is_dir($path)) { ref\file::untrailingslash($path, true); $base = dirname($path); while ($base && ('.' !== $base) && !@is_dir($base)) { $base = dirname($base); } if (!@mkdir($path, 0777, true)) { return false; } if ($path !== $base) { if (!$base || ('.' === $base)) { $base = __DIR__; } if (0 !== mb::strpos($path, $base)) { return true; } $path = mb::substr($path, mb::strlen($base), null, true); ref\file::unleadingslash($path, true); $parts = explode('/', $path); $path = $base; foreach ($parts as $v) { $path .= ('/' === substr($path, -1)) ? $v : "/$v"; if (!@chmod($path, $chmod)) { return true; } } } else { @chmod($path, $chmod); } } return true; } public static function path($path, bool $validate=true, bool $constringent=false) { ref\file::path($path, $validate, $constringent); return $path; } public static function readfile_chunked(string $file, bool $retbytes=true) { if (!$file || !@is_file($file)) { return false; } $buffer = ''; $cnt = 0; $chunk_size = 1024 * 1024; if (false === ($handle = @fopen($file, 'rb'))) { return false; } while (!@feof($handle)) { $buffer = @fread($handle, $chunk_size); echo $buffer; ob_flush(); flush(); if ($retbytes) { $cnt += strlen($buffer); } } $status = @fclose($handle); if ($retbytes && $status) { return $cnt; } return $status; } public static function redirect(string $to) { ref\sanitize::url($to); unset($_POST); unset($_GET); unset($_REQUEST); if (!headers_sent()) { header("Location: $to"); } else { echo "<script>top.location.href='" . str_replace("'", "\'", $to) . "';</script>"; } exit; } public static function rmdir(string $path) { ref\file::path($path, true); if (!$path || !@is_readable($path) || !@is_dir($path)) { return false; } if ($handle = @opendir($path)) { while (false !== ($entry = @readdir($handle))) { if (('.' === $entry) || ('..' === $entry)) { continue; } $file = "{$path}{$entry}"; if (@is_file($file)) { @unlink($file); } else { static::rmdir($file); } } closedir($handle); } if (static::empty_dir($path)) { @rmdir($path); } return !@file_exists($path); } public static function scandir($path, bool $show_files=true, bool $show_dirs=true, int $depth=-1) { ref\file::path($path, true); if (!$path || !@is_dir($path) || (!$show_files && !$show_dirs)) { return array(); } if ($depth < 0) { $inner_depth = -1; } elseif ($depth >= 1) { $inner_depth = $depth - 1; } else { $inner_depth = 0; } $out = array(); if ($handle = @opendir($path)) { ref\file::trailingslash($path, true); while (false !== ($file = @readdir($handle))) { if (('.' === $file) || ('..' === $file)) { continue; } if (@is_file("{$path}{$file}")) { if ($show_files) { $out[] = "{$path}{$file}"; } } elseif (@is_dir("{$path}{$file}")) { if ($show_dirs) { $out[] = "{$path}{$file}"; } if ((-1 === $inner_depth) || $inner_depth > 0) { $out = array_merge($out, static::scandir("{$path}{$file}", $show_files, $show_dirs, $inner_depth)); } } } closedir($handle); } sort($out); return $out; } public static function trailingslash($path, bool $constringent=false) { ref\file::trailingslash($path, $constringent); return $path; } public static function unixslash($path, bool $constringent=false) { ref\file::unixslash($path, $constringent); return $path; } public static function unleadingslash($path, bool $constringent=false) { ref\file::unleadingslash($path, $constringent); return $path; } public static function unparse_url($parsed=null) { $url = ''; $parsed = data::parse_args($parsed, constants::URL_PARTS); ref\mb::trim($parsed, true); $parsed = array_filter($parsed, 'strlen'); if (!count($parsed)) { return false; } if (isset($parsed['scheme'])) { $url = "{$parsed['scheme']}:"; } if (isset($parsed['host'])) { if ($url) { $url .= '//'; } if (isset($parsed['user'])) { $url .= $parsed['user']; if (isset($parsed['pass'])) { $url .= ":{$parsed['pass']}"; } $url .= '@'; } $url .= (filter_var($parsed['host'], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) ? "[{$parsed['host']}]" : $parsed['host']); if (isset($parsed['port'])) { $url .= ":{$parsed['port']}"; } if (isset($parsed['path']) && (0 !== strpos($parsed['path'], '/'))) { $url .= '/'; } } if (isset($parsed['path'])) { $url .= $parsed['path']; } if (isset($parsed['query'])) { $url .= "?{$parsed['query']}"; } if (isset($parsed['fragment'])) { $url .= "#{$parsed['fragment']}"; } return $url ? $url : false; } public static function untrailingslash($path, bool $constringent=false) { ref\file::untrailingslash($path, $constringent); return $path; } } 