<?php
 namespace blobfolio\wp\musty\vendor\common\ref; use \blobfolio\wp\musty\vendor\common\constants; use \blobfolio\wp\musty\vendor\common\data; use \blobfolio\wp\musty\vendor\common\dom; use \blobfolio\wp\musty\vendor\common\file as v_file; use \blobfolio\wp\musty\vendor\common\mb as v_mb; use \blobfolio\wp\musty\vendor\common\sanitize as v_sanitize; use \blobfolio\wp\musty\vendor\domain\domain; class sanitize { protected static $_mb; public static function accents(&$str, bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::accents($str[$k]); } } else { cast::constringent($str, $constringent); if (preg_match('/[\x80-\xff]/', $str)) { $str = strtr($str, constants::ACCENT_CHARS); } } return true; } public static function attribute_value(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::attribute_value($str[$k]); } } else { cast::constringent($str, $constringent); static::control_characters($str, true); format::decode_entities($str); mb::trim($str, true); } return true; } public static function ca_postal_code(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::ca_postal_code($str[$k]); } } else { if (!is_string($str)) { $str = ''; return false; } $str = strtoupper($str); $str = preg_replace('/[^A-CEGHJ-NPR-TV-Z\d]/', '', $str); if (!preg_match('/^[A-VXY][\d][A-Z][\d][A-Z][\d]$/', $str)) { $str = ''; } else { $str = substr($str, 0, 3) . ' ' . substr($str, -3); } } return true; } public static function cc(&$ccnum='') { if (!is_string($ccnum)) { if (is_numeric($ccnum)) { $ccnum = (string) $ccnum; } else { $ccnum = false; return false; } } $ccnum = preg_replace('/[^\d]/', '', $ccnum); $str = $ccnum; if (!$ccnum) { $ccnum = false; return false; } switch ($ccnum[0]) { case '3': if ((strlen($ccnum) !== 15) || !preg_match('/3[47]/', $ccnum)) { $ccnum = false; return false; } break; case '4': if (!in_array(strlen($ccnum), array(13, 16), true)) { $ccnum = false; return false; } break; case '5': if ((strlen($ccnum) !== 16) || !preg_match('/5[1-5]/', $ccnum)) { $ccnum = false; return false; } break; case '6': if ( (strlen($ccnum) !== 16) || (0 !== strpos($ccnum, '6011')) ) { $ccnum = false; return false; } break; default: $ccnum = false; return false; } $dig = str_split($ccnum); $numdig = count($dig); $j = 0; for ($i = ($numdig - 2); $i >= 0; $i -= 2) { $dbl[$j] = $dig[$i] * 2; ++$j; } $dblsz = count($dbl); $validate = 0; for ($i = 0; $i < $dblsz; ++$i) { $add = str_split($dbl[$i]); for ($j = 0; $j < count($add); ++$j) { $validate += $add[$j]; } $add = ''; } for ($i = ($numdig - 1); $i >= 0; $i -= 2) { $validate += $dig[$i]; } if (intval(substr($validate, -1)) === 0) { $ccnum = $str; } else { $ccnum = false; } return true; } public static function control_characters(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::control_characters($str[$k]); } } else { cast::constringent($str, $constringent); $str = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F]/', '', $str); $str = preg_replace('/\\\\+0+/', '', $str); } return true; } public static function country(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::country($str[$k]); } } else { cast::constringent($str, $constringent); static::whitespace($str, 0, true); mb::strtoupper($str, false, true); if (!isset(constants::COUNTRIES[$str])) { $found = false; foreach (constants::COUNTRIES as $k=>$v) { if (v_mb::strtoupper($v['name']) === $str) { $str = $k; $found = true; break; } } if (!$found) { $map = array( 'BRITAIN'=>'GB', 'GREAT BRITAIN'=>'GB', 'U. S. A.'=>'US', 'U. S. S. R.'=>'RU', 'U.S.A.'=>'US', 'U.S.S.R.'=>'RU', 'UNITED STATES OF AMERICA'=>'US', 'UNITED STATES'=>'US', 'USSR'=>'RU', ); if (isset($map[$str])) { $str = $map[$str]; $found = true; } } if (!$found) { $str = ''; } } } return true; } public static function csv(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::csv($str[$k]); } } else { cast::constringent($str, $constringent); static::quotes($str, true); static::whitespace($str, 0, true); while (false !== strpos($str, '""')) { $str = str_replace('""', '"', $str); } $str = str_replace('"', '""', $str); } return true; } public static function datetime(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::datetime($str[$k]); } } else { if (!is_string($str)) { if (is_numeric($str)) { $str = (string) $str; } else { $str = '0000-00-00 00:00:00'; return true; } } if (preg_match('/^\d{9,}$/', $str)) { $str = date('Y-m-d H:i:s', intval($str)); return true; } $str = trim($str); if ( !$str || (0 === strpos($str, '0000-00-00')) || (false === ($str = strtotime($str))) ) { $str = '0000-00-00 00:00:00'; return true; } $str = date('Y-m-d H:i:s', $str); } return true; } public static function date(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::date($str[$k]); } } else { static::datetime($str); $str = substr($str, 0, 10); } return true; } public static function domain(&$str='', bool $unicode=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::domain($str[$k], $unicode); } } else { $host = new domain($str, true); if ($host->is_fqdn() && !$host->is_ip()) { $str = $host->get_host($unicode); } else { $str = ''; return false; } } return true; } public static function ean(&$str, bool $formatted=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::ean($str[$k], $formatted); } } else { if (!is_string($str)) { if (!is_numeric($str)) { $str = ''; return false; } $str = (string) $str; } $str = preg_replace('/[^\d]/', '', $str); $str = str_pad($str, 13, '0', STR_PAD_LEFT); while (isset($str[13]) && (0 === strpos($str, '0'))) { $str = substr($str, 1); } if (strlen($str) !== 13 || ('0000000000000' === $str)) { $str = ''; return false; } while (!static::gtin($str) && strlen($str) <= 18) { $str = "0$str"; } if (!static::gtin($str)) { $str = ''; return false; } if ($formatted) { $str = preg_replace('/^(\d{1})(\d{6})(\d{6})$/', '$1-$2-$3', $str); } } return true; } public static function email(&$str=null, bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::email($str[$k]); } } else { cast::constringent($str, $constringent); static::quotes($str, true); mb::strtolower($str, false, true); $str = preg_replace('/\([^)]*\)/u', '', $str); $str = str_replace(array("'", '"'), '', $str); if (substr_count($str, '@') === 1) { $parts = explode('@', $str); $parts[0] = preg_replace('/[^\.a-z0-9\!#\$%&\*\+\-\=\?_~]/u', '', $parts[0]); $parts[0] = ltrim($parts[0], '.'); $parts[0] = rtrim($parts[0], '.'); if (!$parts[0]) { $str = ''; return true; } $domain = new domain($parts[1]); if (!$domain->is_valid() || !$domain->is_fqdn() || $domain->is_ip()) { $str = ''; return true; } $parts[1] = (string) $domain; $str = implode('@', $parts); } else { $str = ''; return true; } } return true; } public static function file_extension(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::file_extension($str[$k]); } } else { cast::constringent($str, $constringent); mb::strtolower($str, false, true); $str = preg_replace('/\s/u', '', $str); $str = ltrim($str, '*.'); } return true; } protected static function gtin(string $str) { $str = preg_replace('/[^\d]/', '', $str); $code = str_split(substr($str, 0, -1)); $check = (int) substr($str, -1); $total = 0; for ($x = count($code) - 1; $x >= 0; --$x) { $total += (($x % 2) * 2 + 1 ) * $code[$x]; } $checksum = (10 - ($total % 10)); return $checksum === $check; } public static function html(&$str=null, bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::html($str[$k]); } } else { cast::constringent($str, $constringent); $str = htmlspecialchars($str, ENT_QUOTES | ENT_HTML5, 'UTF-8'); } return true; } public static function hostname(&$domain, bool $www=false, bool $unicode=false, bool $constringent=false) { cast::constringent($domain, true, $constringent); $host = new domain($domain, !$www); if (!$host->is_valid()) { $domain = false; return false; } $domain = $host->get_host($unicode); return true; } public static function ip(&$str='', bool $restricted=false, bool $condense=true) { if (is_array($str)) { foreach ($str as $k=>$v) { static::ip($str[$k], $restricted, $condense); } } else { if (!is_string($str)) { $str = ''; return false; } $str = preg_replace('/[^\d\.\:a-f]/', '', strtolower($str)); if (preg_match('/^\[[\d\.\:a-f]+\]$/', $str)) { $str = substr($str, 1, -1); } if ((0 === strpos($str, '::')) && (false !== strpos($str, '.'))) { $str = substr($str, 2); } if (filter_var($str, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) { if ($condense) { $str = inet_ntop(inet_pton($str)); } else { $hex = unpack('H*hex', inet_pton($str)); $str = substr(preg_replace('/([a-f\d]{4})/', '$1:', $hex['hex']), 0, -1); } } elseif (!filter_var($str, FILTER_VALIDATE_IP)) { $str = ''; } if ( !$restricted && $str && !filter_var($str, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) ) { $str = ''; } } return true; } public static function iri_value(&$str='', $protocols=null, $domains=null, bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::iri_value($str[$k], $protocols, $domains); } } else { cast::constringent($str, $constringent); static::attribute_value($str, true); cast::array($protocols); $allowed_protocols = array_merge(constants::SVG_WHITELIST_PROTOCOLS, $protocols); mb::strtolower($allowed_protocols, false, true); $allowed_protocols = array_map('trim', $allowed_protocols); $allowed_protocols = array_filter($allowed_protocols, 'strlen'); $allowed_protocols = array_unique($allowed_protocols); sort($allowed_protocols); cast::array($domains); $allowed_domains = array_merge(constants::SVG_WHITELIST_DOMAINS, $domains); static::domain($allowed_domains); $allowed_domains = array_filter($allowed_domains, 'strlen'); $allowed_domains = array_unique($allowed_domains); sort($allowed_domains); $str = preg_replace('/^\/\//', 'https://', $str); $str = preg_replace('/\v/u', '', $str); $test = preg_replace('/\s/', '', $str); mb::strtolower($test, true); if (false !== strpos($test, ':')) { $test = explode(':', $test); if (!in_array($test[0], $allowed_protocols, true)) { $str = ''; return true; } } if (filter_var($str, FILTER_SANITIZE_URL) !== $str) { $str = ''; return true; } if (preg_match('/^[\w\d]+:\/\//i', $str)) { $domain = v_sanitize::domain($str); if ($domain && !in_array($domain, $allowed_domains, true)) { $str = ''; } } } return true; } public static function isbn(&$str) { if (is_array($str)) { foreach ($str as $k=>$v) { static::isbn($str[$k]); } } else { if (!is_string($str)) { if (is_numeric($str)) { $str = (string) $str; } else { $str = ''; return false; } } $str = strtoupper($str); $str = preg_replace('/[^\dX]/', '', $str); if (!isset($str[10])) { $str = str_pad($str, 10, '0', STR_PAD_LEFT); } elseif (!isset($str[12])) { $str = preg_replace('/[^\d]/', '', $str); $str = str_pad($str, 13, '0', STR_PAD_LEFT); } if ( ('0000000000' === $str) || ('0000000000000' === $str) || isset($str[13]) ) { $str = ''; return false; } if (strlen($str) === 10) { $checksum = 0; for ($x = 0; $x < 9; ++$x) { if ('X' === $str[$x]) { $checksum += 10 * (10 - $x); } else { $checksum += intval($str[$x]) * (10 - $x); } } $checksum = 11 - $checksum % 11; if (10 === $checksum) { $checksum = 'X'; } elseif (11 === $checksum) { $checksum = 0; } else { $checksum = (int) $checksum; } $check = ('X' === $str[9]) ? 'X' : intval($str[9]); if ($check !== $checksum) { $str = ''; return false; } } else { if (!static::gtin($str)) { $str = ''; return false; } } } return true; } public static function js(&$str='', $quote="'", bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::js($str[$k], $quote); } } else { cast::constringent($str, $constringent); sanitize::quotes($str, true); sanitize::whitespace($str, 0, true); $str = str_replace('/', '\\/', $str); if ("'" === $quote) { $str = str_replace("'", "\'", $str); } elseif ('"' === $quote) { $str = str_replace('"', '\"', $str); } } return true; } public static function mime(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::mime($str[$k]); } } else { if (!is_string($str)) { if (is_numeric($str)) { $str = (string) $str; } else { $str = ''; return false; } } $str = strtolower($str); $str = preg_replace('/[^-+*.a-z0-9\/]/', '', $str); } return true; } public static function name(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::name($str[$k]); } } else { cast::constringent($str, $constringent); static::quotes($str, true); static::whitespace($str, 0, true); $str = preg_replace('/[^\p{L}\p{Zs}\p{Pd}\d\'\"\,\.]/u', '', $str); static::whitespace($str, 0, true); mb::ucwords($str, false, true); } return true; } public static function password(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::password($str[$k]); } } else { cast::constringent($str, $constringent); static::printable($str, true); static::whitespace($str, 0, true); } return true; } public static function printable(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::printable($str[$k]); } } else { cast::constringent($str, $constringent); $str = preg_replace('/[\x{200B}-\x{200D}\x{FEFF}]/u', '', $str); $str = str_replace("\r\n", "\n", $str); $str = str_replace("\r", "\n", $str); $str = preg_replace_callback( '/[^[:print:]]/u', function($match) { if ( ("\n" === $match[0]) || ("\t" === $match[0]) ) { return $match[0]; } return ''; }, $str ); } return true; } public static function province(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::province($str[$k]); } } else { cast::constringent($str, $constringent); static::whitespace($str, 0, true); $str = strtoupper($str); if (!isset(constants::PROVINCES[$str])) { if (false === ($str = data::array_isearch($str, constants::PROVINCES, true))) { $str = ''; } } } return true; } public static function quotes(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::quotes($str[$k]); } } else { cast::constringent($str, $constringent); $from = array_keys(constants::QUOTE_CHARS); $to = array_values(constants::QUOTE_CHARS); $str = str_replace($from, $to, $str); } return true; } public static function state(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::state($str[$k]); } } else { cast::constringent($str, $constringent); static::whitespace($str, 0, true); $str = strtoupper($str); if (!isset(constants::STATES[$str])) { if (false === ($str = data::array_isearch($str, constants::STATES, true))) { $str = ''; } } } return true; } public static function au_state(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::au_state($str[$k]); } } else { cast::constringent($str, $constringent); static::whitespace($str, 0, true); $str = strtoupper($str); if (!isset(constants::STATES_AU[$str])) { if (false === ($str = data::array_isearch($str, constants::STATES_AU, true))) { $str = ''; } } } return true; } public static function svg(&$str='', $tags=null, $attr=null, $protocols=null, $domains=null) { cast::string($str, true); cast::array($tags); cast::array($attr); cast::array($protocols); cast::array($domains); $allowed_tags = array_merge(constants::SVG_WHITELIST_TAGS, $tags); mb::strtolower($allowed_tags); $allowed_tags = array_map('trim', $allowed_tags); $allowed_tags = array_filter($allowed_tags, 'strlen'); $allowed_tags = array_unique($allowed_tags); sort($allowed_tags); $allowed_attributes = array_merge(constants::SVG_WHITELIST_ATTR, $attr); mb::strtolower($allowed_attributes); $allowed_attributes = array_map('trim', $allowed_attributes); $allowed_attributes = array_filter($allowed_attributes, 'strlen'); $allowed_attributes = array_unique($allowed_attributes); sort($allowed_attributes); $allowed_protocols = array_merge(constants::SVG_WHITELIST_PROTOCOLS, $protocols); mb::strtolower($allowed_protocols); $allowed_protocols = array_map('trim', $allowed_protocols); $allowed_protocols = array_filter($allowed_protocols, 'strlen'); $allowed_protocols = array_unique($allowed_protocols); sort($allowed_protocols); $allowed_domains = array_merge(constants::SVG_WHITELIST_DOMAINS, $domains); static::domain($allowed_domains); $allowed_domains = array_filter($allowed_domains, 'strlen'); $allowed_domains = array_unique($allowed_domains); sort($allowed_domains); $iri_attributes = constants::SVG_IRI_ATTRIBUTES; $dom = dom::load_svg($str); $svg = $dom->getElementsByTagName('svg'); if (!$svg->length) { $str = ''; return false; } $xpath = new \DOMXPath($dom); $tags = $dom->getElementsByTagName('*'); for ($x = $tags->length - 1; $x >= 0; $x--) { $tag = $tags->item($x); $tag_name = v_mb::strtolower($tag->tagName, false, true); if ( (false !== strpos($tag_name, ':')) && !in_array($tag_name, $allowed_tags, true) ) { $tag_name = explode(':', $tag_name); $tag_name = $tag_name[1]; } if (!in_array($tag_name, $allowed_tags, true)) { dom::remove_node($tag); continue; } if ('style' === $tag_name) { $style = strip_tags(v_sanitize::attribute_value($tag->textContent, true)); $tag->textContent = $style; } $attributes = $xpath->query('.//@*', $tag); for ($y = $attributes->length - 1; $y >= 0; $y--) { $attribute = $attributes->item($y); $attribute_name = v_mb::strtolower($attribute->nodeName, false, true); if ( !in_array($attribute_name, $allowed_attributes, true) && (false !== ($start = v_mb::strpos($attribute_name, ':'))) ) { $attribute_name = v_mb::substr($attribute_name, $start + 1, null, true); } if ( (0 !== strpos($attribute_name, 'data-')) && !in_array($attribute_name, $allowed_attributes, true) ) { $tag->removeAttribute($attribute->nodeName); continue; } $attribute_value = v_sanitize::attribute_value($attribute->value, true); $iri = false; if (in_array($attribute_name, $iri_attributes, true)) { $iri = true; static::iri_value($attribute_value, $allowed_protocols, $allowed_domains, true); } elseif (preg_match('/(?:\w+script):/xi', $attribute_value)) { $attribute_value = ''; } if ($attribute_value !== $attribute->value) { if ($iri) { $tag->removeAttribute($attribute->nodeName); } else { $tag->setAttribute($attribute->nodeName, $attribute_value); } } } } $tags = $dom->getElementsByTagName('*'); for ($x = 0; $x < $tags->length; ++$x) { $tag = $tags->item($x); $nodes = $xpath->query('namespace::*', $tag); for ($y = 0; $y < $nodes->length; ++$y) { $node = $nodes->item($y); $node_name = v_mb::strtolower($node->nodeName, false, true); if (0 !== strpos($node_name, 'xmlns:')) { dom::remove_namespace($dom, $node->localName); continue; } $node_value = v_sanitize::iri_value($node->nodeValue, $allowed_protocols, $allowed_domains, true); if (!$node_value) { dom::remove_namespace($dom, $node->localName); } } } $svg = dom::save_svg($dom); $svg = preg_replace_callback( '/url\s*\((.*)\s*\)/Ui', function($match) use($allowed_protocols, $allowed_domains) { $str = v_sanitize::attribute_value($match[1], true); $str = ltrim($str, "'\""); $str = rtrim($str, "'\""); static::iri_value($str, $allowed_protocols, $allowed_domains, true); if ($str) { return "url('$str')"; } return 'none'; }, $svg ); $str = $svg; return true; } public static function timezone(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::timezone($str[$k]); } } elseif (!in_array($str, constants::TIMEZONES, true)) { if (!is_string($str)) { $str = 'UTC'; return false; } $str = preg_replace('/\s/u', '', strtoupper($str)); if (isset(constants::TIMEZONES[$str])) { $str = constants::TIMEZONES[$str]; } else { $str = 'UTC'; } } return true; } public static function to_range(&$value, $min=null, $max=null) { if ( !is_null($min) && !is_null($max) && $min > $max ) { data::switcheroo($min, $max); } if (is_array($value)) { foreach ($value as $k=>$v) { static::to_range($v, $min, $max); } } else { $original = $value; try { if (!is_null($min) && $value < $min) { $value = $min; } if (!is_null($max) && $value > $max) { $value = $max; } } catch (\Throwable $e) { $value = $original; } } return true; } public static function upc(&$str, bool $formatted=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::upc($str[$k], $formatted); } } else { if (!is_string($str)) { if (is_numeric($str)) { $str = (string) $str; } else { $str = ''; return false; } } $str = preg_replace('/[^\d]/', '', $str); $str = str_pad($str, 12, '0', STR_PAD_LEFT); while (isset($str[12]) && (0 === strpos($str, '0'))) { $str = substr($str, 1); } if ((strlen($str) !== 12) || ('000000000000' === $str)) { $str = ''; return false; } $str = "0$str"; if (static::gtin($str)) { $str = substr($str, 1); } else { $str = ''; return false; } if ($formatted) { $str = preg_replace('/^(\d)(\d{5})(\d{5})(\d)$/', '$1-$2-$3-$4', $str); } } return true; } public static function url(&$str='', bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::url($str[$k]); } } else { cast::constringent($str, true); $tmp = v_mb::parse_url($str); if (isset($tmp['scheme'])) { mb::strtolower($tmp['scheme'], false, true); } if (!isset($tmp['host'])) { return false; } $tmp['host'] = new domain($tmp['host']); if (!$tmp['host']->is_valid()) { return false; } $tmp['host'] = (string) $tmp['host']; $str = v_file::unparse_url($tmp); $str = filter_var($str, FILTER_SANITIZE_URL); if (!filter_var($str, FILTER_VALIDATE_URL, FILTER_FLAG_SCHEME_REQUIRED | FILTER_FLAG_HOST_REQUIRED)) { $str = ''; } } return true; } public static function utf8(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::utf8($str[$k]); } } elseif ($str && !is_numeric($str) && !is_bool($str)) { if (!is_string($str)) { try { $str = (string) $str; } catch (\Throwable $e) { $str = ''; } } if (null === static::$_mb) { static::$_mb = ( function_exists('mb_check_encoding') && function_exists('mb_strlen') && (intval(ini_get('mbstring.func_overload'))) & 2 ); } if ( $str && (!static::$_mb || !mb_check_encoding($str, 'ASCII')) ) { if (static::$_mb) { $length = mb_strlen($str, '8bit'); } else { $length = strlen($str); } $out = ''; for ($x = 0; $x < $length; ++$x) { $c1 = $str[$x]; if ($c1 >= "\xc0") { $c2 = $x + 1 >= $length ? "\x00" : $str[$x + 1]; $c3 = $x + 2 >= $length ? "\x00" : $str[$x + 2]; $c4 = $x + 3 >= $length ? "\x00" : $str[$x + 3]; if ($c1 >= "\xc0" & $c1 <= "\xdf") { if ($c2 >= "\x80" && $c2 <= "\xbf") { $out .= $c1 . $c2; ++$x; } else { $cc1 = (chr(ord($c1) / 64) | "\xc0"); $cc2 = ($c1 & "\x3f") | "\x80"; $out .= $cc1 . $cc2; } } elseif ($c1 >= "\xe0" & $c1 <= "\xef") { if ( $c2 >= "\x80" && $c2 <= "\xbf" && $c3 >= "\x80" && $c3 <= "\xbf" ) { $out .= $c1 . $c2 . $c3; $x += 2; } else { $cc1 = (chr(ord($c1) / 64) | "\xc0"); $cc2 = ($c1 & "\x3f") | "\x80"; $out .= $cc1 . $cc2; } } elseif ($c1 >= "\xf0" & $c1 <= "\xf7") { if ( $c2 >= "\x80" && $c2 <= "\xbf" && $c3 >= "\x80" && $c3 <= "\xbf" && $c4 >= "\x80" && $c4 <= "\xbf" ) { $out .= $c1 . $c2 . $c3 . $c4; $x += 3; } else { $cc1 = (chr(ord($c1) / 64) | "\xc0"); $cc2 = ($c1 & "\x3f") | "\x80"; $out .= $cc1 . $cc2; } } else { $cc1 = (chr(ord($c1) / 64) | "\xc0"); $cc2 = (($c1 & "\x3f") | "\x80"); $out .= $cc1 . $cc2; } } elseif (($c1 & "\xc0") === "\x80") { $o1 = ord($c1); if (isset(constants::WIN1252_CHARS[$o1])) { $out .= constants::WIN1252_CHARS[$o1]; } else { $cc1 = (chr($o1 / 64) | "\xc0"); $cc2 = (($c1 & "\x3f") | "\x80"); $out .= $cc1 . $cc2; } } else { $out .= $c1; } } $str = (1 === @preg_match('/^./us', $out)) ? $out : ''; } } return true; } public static function whitespace(&$str='', int $newlines=0, bool $constringent=false) { if (is_array($str)) { foreach ($str as $k=>$v) { static::whitespace($str[$k], $newlines); } } else { if (is_string($str) && !preg_match('/\s/u', $str)) { return true; } cast::constringent($str, $constringent); static::to_range($newlines, 0); if (!$newlines) { $str = preg_replace('/\s+/u', ' ', $str); mb::trim($str, true); return true; } mb::trim($str, true); $str = str_replace("\r\n", "\n", $str); $str = preg_replace('/\v/u', "\n", $str); $str = explode("\n", $str); static::whitespace($str, 0, true); $str = implode("\n", $str); $str = preg_replace('/\n{' . ($newlines + 1) . ',}/', str_repeat("\n", $newlines), $str); $str = trim($str); } return true; } public static function whitespace_multiline(&$str='', int $newlines=1, bool $constringent=false) { static::whitespace($str, $newlines, $constringent); return true; } public static function zip5(&$str='') { if (is_array($str)) { foreach ($str as $k=>$v) { static::zip5($str[$k]); } } else { if (!is_string($str)) { if (is_numeric($str)) { $str = (string) $str; } else { $str = ''; return false; } } $str = preg_replace('/[^\d]/', '', $str); if (!isset($str[4])) { $str = sprintf('%05d', $str); } elseif (isset($str[5])) { $str = substr($str, 0, 5); } if ('00000' === $str) { $str = ''; } } return true; } } 