<?php
 namespace blobfolio\wp\musty\vendor\domain; use \blobfolio\wp\musty\vendor\common\constants; use \blobfolio\wp\musty\vendor\common\data as c_data; use \blobfolio\wp\musty\vendor\common\mb as v_mb; use \blobfolio\wp\musty\vendor\common\ref\cast as r_cast; use \blobfolio\wp\musty\vendor\common\ref\file as r_file; use \blobfolio\wp\musty\vendor\common\ref\mb as r_mb; use \blobfolio\wp\musty\vendor\common\ref\sanitize as r_sanitize; class domain { const HOST_PARTS = array( 'host'=>null, 'subdomain'=>null, 'domain'=>null, 'suffix'=>null, ); protected $host; protected $subdomain; protected $domain; protected $suffix; protected $dns; public function __construct($host='', bool $www=false) { if (false === ($parsed = static::parse_host_parts($host))) { return false; } $this->host = $parsed['host']; $this->subdomain = $parsed['subdomain']; $this->domain = $parsed['domain']; $this->suffix = $parsed['suffix']; if ($www) { $this->strip_www(); } return true; } public static function parse_host($host) { $tmp = v_mb::parse_url($host, PHP_URL_HOST); if ($tmp) { $host = $tmp; } else { r_cast::string($host, true); r_mb::trim($host, true); if (false !== ($start = v_mb::strpos($host, '/'))) { $host = v_mb::substr($host, 0, $start, true); } if (false !== ($start = v_mb::strpos($host, '?'))) { $host = v_mb::substr($host, 0, $start, true); } if (false !== ($start = v_mb::strpos($host, '@'))) { $host = v_mb::substr($host, $start + 1, null, true); } if (filter_var($host, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) { r_sanitize::ip($host, true); } elseif ( (0 === strpos($host, '[')) && false !== ($end = v_mb::strpos($host, ']')) ) { $host = v_mb::substr($host, 1, $end - 1, true); r_sanitize::ip($host, true); } elseif (false !== ($start = v_mb::strpos($host, ':'))) { $host = v_mb::substr($host, 0, $start, true); } if (!strlen($host)) { return false; } if (function_exists('idn_to_ascii')) { $host = explode('.', $host); r_file::idn_to_ascii($host); $host = implode('.', $host); } r_mb::strtolower($host, false, true); $host = ltrim($host, '.'); $host = rtrim($host, '.'); } if (0 === strpos($host, '[')) { $host = str_replace(array('[', ']'), '', $host); r_sanitize::ip($host, true); } if (filter_var($host, FILTER_VALIDATE_IP)) { return $host; } if (preg_match('/[^a-z\d\-\.]/u', $host)) { return false; } $host = explode('.', $host); foreach ($host as $v) { if ( !strlen($v) || (0 === strpos($v, '-')) || ('-' === substr($v, -1)) ) { return false; } } return implode('.', $host); } public static function parse_host_parts($host) { if (false === ($host = static::parse_host($host))) { return false; } $out = static::HOST_PARTS; if (filter_var($host, FILTER_VALIDATE_IP)) { $out['host'] = $host; $out['domain'] = $host; return $out; } $suffixes = data::SUFFIXES; $suffix = array(); $parts = explode('.', $host); $parts = array_reverse($parts); foreach ($parts as $k=>$part) { if (isset($suffixes[$part], $suffixes[$part]['!'])) { break; } if (isset($suffixes[$part])) { array_unshift($suffix, $part); $suffixes = $suffixes[$part]; unset($parts[$k]); continue; } if (isset($suffixes['*'])) { array_unshift($suffix, $part); $suffixes = $suffixes['*']; unset($parts[$k]); continue; } break; } if (!count($parts)) { return false; } $parts = array_reverse($parts); $out['domain'] = array_pop($parts); if (count($parts)) { $out['subdomain'] = implode('.', $parts); } if (count($suffix)) { $out['suffix'] = implode('.', $suffix); } $out['host'] = $host; return $out; } public function strip_www() { if (!$this->is_valid() || is_null($this->subdomain)) { return false; } if ( ('www' === $this->subdomain) || (0 === strpos($this->subdomain, 'www.')) ) { $this->subdomain = preg_replace('/^www\.?/u', '', $this->subdomain); if (!strlen($this->subdomain)) { $this->subdomain = null; } $this->host = preg_replace('/^www\./u', '', $this->host); return true; } return false; } public function is_valid(bool $dns=false) { return !is_null($this->host) && (!$dns || $this->has_dns()); } public function is_fqdn() { return ( $this->is_valid() && (is_string($this->suffix) || $this->is_ip(false)) ); } public function is_ip(bool $restricted=true) { if (!$this->is_valid()) { return false; } if ($restricted) { return !!filter_var($this->host, FILTER_VALIDATE_IP); } return !!filter_var( $this->host, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ); } public function has_dns() { if (is_null($this->dns)) { if (!$this->is_fqdn()) { $this->dns = false; } elseif ($this->is_ip()) { $this->dns = $this->is_ip(false); } else { $this->dns = !!filter_var( gethostbyname("{$this->host}."), FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ); } } return $this->dns; } public function is_ascii() { if (!$this->is_valid()) { return false; } return !$this->is_unicode(); } public function is_unicode() { if (!$this->is_valid() || $this->is_ip() || !function_exists('idn_to_utf8')) { return false; } return ($this->to_unicode('host') !== $this->host); } public function __toString() { return $this->is_valid() ? $this->host : ''; } public function __call($method, $args) { preg_match_all('/^get_(.+)$/', $method, $matches); if ( count($matches[0]) && ('dns' !== $matches[1][0]) && property_exists($this, $matches[1][0]) ) { $variable = $matches[1][0]; if (is_array($args) && count($args)) { $args = c_data::array_pop_top($args); r_cast::bool($args); if ($args) { return $this->to_unicode($variable); } } return $this->{$variable}; } throw new \Exception( sprintf( 'The required method "%s" does not exist for %s', $method, get_called_class() ) ); } protected function to_unicode($key) { $value = $this->{$key}; if (function_exists('idn_to_utf8') && is_string($value)) { $value = explode('.', $value); r_file::idn_to_utf8($value); return implode('.', $value); } return $value; } public function get_data(bool $unicode=false) { if (!$this->is_valid()) { return false; } return array( 'host'=>$this->get_host($unicode), 'subdomain'=>$this->get_subdomain($unicode), 'domain'=>$this->get_domain($unicode), 'suffix'=>$this->get_suffix($unicode), ); } } 