#!/sbin/sh

SKIPUNZIP=1

AdGuardHome_dir="/data/AdGuardHome"

if [ ${BOOTMODE} ! = true ] ; then
    abort "! Please install in Magisk Manager"
fi

ui_print "- Extracting module files."
unzip -o "${ZIPFILE}" -x 'META-INF/*' -d ${MODPATH} >&2

if [ ! -d /data/adb/service.d ] ; then
  mkdir -p /data/adb/service.d
fi
mv -f ${MODPATH}/AdGuardHome_For_Magisk_service.sh /data/adb/service.d/
set_perm /data/adb/service.d/AdGuardHome_For_Magisk_service.sh 0 0 0700

online_mod() {
    ui_print "- Start online installation."
    AdGuardHome_link="https://github.com/AdguardTeam/AdGuardHome/releases"
    if $(curl -V > /dev/null 2>&1) ; then
        flag="true"
        latest_version=`curl -k -s -I "${AdGuardHome_link}/latest" | grep -i location | grep -o "tag.*" | grep -o "v[0-9.]*"`
    elif $(wget --help > /dev/null 2>&1) ; then
        flag="false"
        touch ${TMPDIR}/version
        wget --no-check-certificate -O ${TMPDIR}/version "${AdGuardHome_link}/latest"
        latest_version=`cat ${TMPDIR}/version | grep -o "tag.*" | grep -o "v[0-9.]*" | head -n1`
    else
        abort "! Please install the busybox module and try again."
    fi

    if [ "${latest_version}" = "" ] ; then
        abort "Error: Connect AdGuardHome download link failed."
    fi

    ui_print "- Download latest AdGuardHome ${latest_version}-${ARCH}."
    case "${ARCH}" in
        arm)
            download_AdGuardHome_link="${AdGuardHome_link}/download/${latest_version}/AdGuardHome_linux_armv7.tar.gz"
            ;;
        arm64)
            download_AdGuardHome_link="${AdGuardHome_link}/download/${latest_version}/AdGuardHome_linux_arm64.tar.gz"
            ;;
        x86)
            download_AdGuardHome_link="${AdGuardHome_link}/download/${latest_version}/AdGuardHome_linux_386.tar.gz"
            ;;
        x64)
            download_AdGuardHome_link="${AdGuardHome_link}/download/${latest_version}/AdGuardHome_linux_amd64.tar.gz"
            ;;
        esac

    if [ ${flag} == "true" ] ; then
        curl "${download_AdGuardHome_link}" -k -L -o "${MODPATH}/AdGuardHome.tar.gz" >&2
    else
        wget --no-check-certificate -O "${MODPATH}/AdGuardHome.tar.gz" "${download_AdGuardHome_link}" >&2
    fi

    if [ "$?" ! = "0"] ; then
        abort "Error: Download AdGuardHome Core failed."
    fi

    tar -zxvf ${MODPATH}/AdGuardHome.tar.gz -C ${MODPATH} >&2
    mkdir -p ${AdGuardHome_dir}
    mv -f ${MODPATH}/AdGuardHome/AdGuardHome ${AdGuardHome_dir}/
    set_perm ${AdGuardHome_dir}/AdGuardHome 0 3005 0700
    rm -rf ${MODPATH}/AdGuardHome
    rm -f ${MODPATH}/AdGuardHome.tar.gz
    rm -rf ${MODPATH}/Core
}

online_mod

ui_print "- Update module.prop."
rm -f ${MODPATH}/module.prop
touch ${MODPATH}/module.prop
echo "id=AdGuardHome_For_Magisk" > ${MODPATH}/module.prop
echo "name=AdGuardHome For Magisk" >> ${MODPATH}/module.prop
echo -n "version=" >> ${MODPATH}/module.prop
echo ${latest_version} >> ${MODPATH}/module.prop
echo "versionCode=$(date +%Y%m%d)" >> ${MODPATH}/module.prop
echo "author=Module by CHIZI-0618. Core by AdguardTeam." >> ${MODPATH}/module.prop
echo "description=Build AdGuard Home DNS server by Magisk." >> ${MODPATH}/module.prop

ui_print "- Start setting permissions."
set_perm_recursive ${MODPATH} 0 0 0755 0644
set_perm_recursive ${MODPATH}/scripts 0 0 0755 0755
